/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import net.william278.papiproxybridge.libraries.reactor.core.CoreSubscriber;
import net.william278.papiproxybridge.libraries.reactor.core.Fuseable;
import net.william278.papiproxybridge.libraries.reactor.core.Scannable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.FluxMap;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.InternalMonoOperator;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Mono;

final class MonoMap<T, R>
extends InternalMonoOperator<T, R> {
    final Function<? super T, ? extends R> mapper;

    MonoMap(Mono<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            return new FluxMap.MapConditionalSubscriber<T, R>(cs, this.mapper);
        }
        return new FluxMap.MapSubscriber<T, R>(actual, this.mapper);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

