/*
 * Decompiled with CFR 0.152.
 */
package net.william278.papiproxybridge.libraries.reactor.core.publisher;

import net.william278.papiproxybridge.libraries.reactor.core.CoreSubscriber;
import net.william278.papiproxybridge.libraries.reactor.core.Scannable;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.InternalProducerAttr;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.Operators;
import net.william278.papiproxybridge.libraries.reactor.core.publisher.ParallelFlux;

class ParallelFluxRestoringThreadLocals<T>
extends ParallelFlux<T>
implements Scannable {
    private final ParallelFlux<? extends T> source;

    ParallelFluxRestoringThreadLocals(ParallelFlux<? extends T> source) {
        this.source = source;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(CoreSubscriber<? super T>[] subscribers) {
        CoreSubscriber<? super T>[] actualSubscribers = Operators.restoreContextOnSubscribers(this.source, subscribers);
        this.source.subscribe(actualSubscribers);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.source;
        }
        if (key == Scannable.Attr.PREFETCH) {
            return this.getPrefetch();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        if (key == InternalProducerAttr.INSTANCE) {
            return true;
        }
        return null;
    }
}

