/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.materials.json.MaterialListJsonBase;
import fi.dy.masa.litematica.materials.json.MaterialListJsonOverrides;
import fi.dy.masa.malilib.mixin.recipe.IMixinIngredient;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import org.apache.commons.lang3.math.Fraction;
import org.apache.commons.lang3.tuple.Pair;

public class MaterialListJsonEntry {
    private final List<MaterialListJsonBase> requirements = new ArrayList<MaterialListJsonBase>();
    private final class_6880<class_1792> inputItem;
    private final int total;
    private final Type type;
    private boolean hasOutput = false;
    private class_10298 primaryId;
    private HashMap<class_10298, List<class_1856>> recipeRequirements;
    private HashMap<class_10298, class_10355> recipeCategory;
    private HashMap<class_10298, RecipeBookUtils.Type> recipeTypes;

    private MaterialListJsonEntry(class_6880<class_1792> inputItem, int total, Type type) {
        this.inputItem = inputItem;
        this.total = total;
        this.type = type;
    }

    @Nullable
    public static MaterialListJsonEntry build(class_6880<class_1792> input, int total, List<RecipeBookUtils.Type> types, @Nullable class_6880<class_1792> prevItem, boolean craftingOnly) {
        class_310 mc = class_310.method_1551();
        if (input == null || mc.field_1687 == null) {
            return null;
        }
        Pair<class_6880<class_1792>, Integer> itemOverride = MaterialListJsonOverrides.INSTANCE.matchOverride(input, total);
        if (types.isEmpty()) {
            return new MaterialListJsonEntry((class_6880<class_1792>)((class_6880)itemOverride.getLeft()), (Integer)itemOverride.getRight(), Type.EMPTY);
        }
        class_1799 shadow = new class_1799((class_6880)itemOverride.getLeft());
        List lookup = RecipeBookUtils.getDisplayEntryFromRecipeBook((class_1799)shadow, types);
        class_10352 map = RecipeBookUtils.getMap((class_310)mc);
        if (lookup.isEmpty() || MaterialListJsonOverrides.INSTANCE.shouldKeepItemOrBlock((class_6880<class_1792>)((class_6880)itemOverride.getLeft()))) {
            return new MaterialListJsonEntry((class_6880<class_1792>)((class_6880)itemOverride.getLeft()), (Integer)itemOverride.getRight(), Type.LAST);
        }
        int lookupCount = lookup.size();
        Type outType = lookupCount > 1 ? Type.MULTI : Type.ONE;
        MaterialListJsonEntry result = new MaterialListJsonEntry((class_6880<class_1792>)((class_6880)itemOverride.getLeft()), (Integer)itemOverride.getRight(), outType);
        result.recipeRequirements = new HashMap();
        result.recipeCategory = new HashMap();
        result.recipeTypes = new HashMap();
        result.hasOutput = true;
        Pair pair = (Pair)lookup.getFirst();
        class_10298 id = (class_10298)pair.getLeft();
        class_10297 entry = (class_10297)pair.getRight();
        List resultStacks = entry.method_64730(map);
        class_1799 resultStack = (class_1799)resultStacks.getFirst();
        int resultCount = resultStack.method_7947();
        class_10355 category = entry.comp_3265();
        RecipeBookUtils.Type type = RecipeBookUtils.Type.fromRecipeDisplay((class_10295)entry.comp_3263());
        if (lookup.size() > 1) {
            RecipeBookUtils.Type altType;
            class_10297 altEntry;
            Pair altPair;
            if (craftingOnly && type == RecipeBookUtils.Type.STONECUTTER) {
                altPair = (Pair)lookup.get(1);
                altEntry = (class_10297)altPair.getRight();
                altType = RecipeBookUtils.Type.fromRecipeDisplay((class_10295)altEntry.comp_3263());
                if (altType == RecipeBookUtils.Type.SHAPED || altType == RecipeBookUtils.Type.SHAPELESS) {
                    id = (class_10298)altPair.getLeft();
                    entry = altEntry;
                    resultStacks = entry.method_64730(map);
                    resultStack = (class_1799)resultStacks.getFirst();
                    resultCount = resultStack.method_7947();
                    category = entry.comp_3265();
                    type = altType;
                }
            } else if (!(craftingOnly || type != RecipeBookUtils.Type.SHAPED && type != RecipeBookUtils.Type.SHAPELESS || (altType = RecipeBookUtils.Type.fromRecipeDisplay((class_10295)(altEntry = (class_10297)(altPair = (Pair)lookup.get(1)).getRight()).comp_3263())) != RecipeBookUtils.Type.STONECUTTER)) {
                id = (class_10298)altPair.getLeft();
                entry = altEntry;
                resultStacks = entry.method_64730(map);
                resultStack = (class_1799)resultStacks.getFirst();
                resultCount = resultStack.method_7947();
                category = entry.comp_3265();
                type = altType;
            }
        }
        if (entry.comp_3266().isPresent()) {
            List ingredients = (List)entry.comp_3266().get();
            if (lookupCount > 1 && MaterialListJsonOverrides.INSTANCE.overrideShouldSkipRecipe((class_6880<class_1792>)((class_6880)itemOverride.getLeft()), ingredients)) {
                pair = (Pair)lookup.get(1);
                id = (class_10298)pair.getLeft();
                entry = (class_10297)pair.getRight();
                if (entry.comp_3266().isPresent()) {
                    resultStacks = entry.method_64730(map);
                    resultStack = (class_1799)resultStacks.getFirst();
                    resultCount = resultStack.method_7947();
                    category = entry.comp_3265();
                    type = RecipeBookUtils.Type.fromRecipeDisplay((class_10295)entry.comp_3263());
                    ingredients = (List)entry.comp_3266().get();
                } else {
                    pair = (Pair)lookup.getFirst();
                    id = (class_10298)pair.getLeft();
                    entry = (class_10297)pair.getRight();
                }
            }
            result.recipeRequirements.put(id, ingredients);
            result.recipeCategory.put(id, category);
            result.recipeTypes.put(id, type);
            result.primaryId = id;
            HashMap<Object, Integer> ded = new HashMap<Object, Integer>();
            for (class_1856 ing : ingredients) {
                class_10302 display = ing.method_64673();
                List displayStacks = display.method_64738(map);
                class_1799 displayStack = (class_1799)displayStacks.getFirst();
                class_6880<class_1792> itemEntry = displayStack.method_41409();
                class_6885 ingEntries = ((IMixinIngredient)ing).malilib_getEntries();
                if (ingEntries.method_40247() > 1) {
                    itemEntry = MaterialListJsonOverrides.INSTANCE.overridePrimaryMaterial((class_6880<class_1792>)ingEntries.method_40240(0));
                    display = new class_10302.class_10306(itemEntry);
                    displayStacks = display.method_64738(map);
                    displayStack = (class_1799)displayStacks.getFirst();
                }
                if (prevItem != null && prevItem == itemEntry) continue;
                int adjustedTotal = (Integer)itemOverride.getRight();
                if (resultCount > 1) {
                    Fraction adjusted = Fraction.getFraction((int)((Integer)itemOverride.getRight()), (int)resultCount);
                    int floor = class_3532.method_15375((float)adjusted.floatValue());
                    float remainderCalc = (float)resultCount * (adjusted.floatValue() - (float)floor);
                    int remainderCount = Math.round(remainderCalc);
                    adjustedTotal = Math.max(floor + (remainderCount > 0 ? 1 : 0), remainderCount > 0 ? 1 : 0);
                }
                if (ded.containsKey(itemEntry)) {
                    int count2 = (Integer)ded.get(itemEntry) + adjustedTotal;
                    ded.put(itemEntry, count2);
                    continue;
                }
                ded.put(itemEntry, adjustedTotal);
            }
            ded.forEach((key, count) -> result.requirements.add(new MaterialListJsonBase((class_6880<class_1792>)key, (int)count, (class_6880<class_1792>)((class_6880)itemOverride.getLeft()), craftingOnly)));
        }
        return result;
    }

    public Type getType() {
        return this.type;
    }

    public class_6880<class_1792> getInputItem() {
        return this.inputItem;
    }

    public List<MaterialListJsonBase> getRequirements() {
        return this.requirements;
    }

    public class_10298 getPrimaryId() {
        return this.primaryId;
    }

    public HashMap<class_10298, List<class_1856>> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public HashMap<class_10298, class_10355> getRecipeCategory() {
        return this.recipeCategory;
    }

    public HashMap<class_10298, RecipeBookUtils.Type> getRecipeTypes() {
        return this.recipeTypes;
    }

    public boolean hasOutput() {
        return this.hasOutput;
    }

    public int getTotal() {
        return this.total;
    }

    public JsonElement toJson(class_6903<?> ops) {
        JsonObject obj = new JsonObject();
        obj.add("Item", (JsonElement)new JsonPrimitive(this.getInputItem().method_55840()));
        obj.add("Count", (JsonElement)new JsonPrimitive((Number)this.getTotal()));
        obj.add("Type", (JsonElement)new JsonPrimitive(this.type.name()));
        if (this.hasOutput()) {
            obj.add("PrimaryId", (JsonElement)new JsonPrimitive((Number)this.getPrimaryId().comp_3267()));
            obj.add("Recipes", (JsonElement)this.lookupResultsToJson(ops));
        }
        return obj;
    }

    private JsonArray lookupResultsToJson(class_6903<?> ops) {
        JsonArray arr = new JsonArray();
        for (class_10298 id : this.recipeRequirements.keySet()) {
            List<class_1856> requires = this.recipeRequirements.get(id);
            class_10355 category = this.recipeCategory.get(id);
            RecipeBookUtils.Type type = this.recipeTypes.get(id);
            JsonObject obj = new JsonObject();
            obj.add("NetworkId", (JsonElement)new JsonPrimitive((Number)id.comp_3267()));
            obj.add("Category", (JsonElement)new JsonPrimitive(RecipeBookUtils.getRecipeCategoryId((class_10355)category)));
            obj.add("Type", (JsonElement)new JsonPrimitive(type.name()));
            JsonArray itemArr = new JsonArray();
            for (class_1856 ing : requires) {
                itemArr.add((JsonElement)class_1856.field_46095.encodeStart(ops, (Object)ing).getPartialOrThrow());
            }
            obj.add("Ingredients", (JsonElement)itemArr);
            JsonArray outputArr = new JsonArray();
            for (MaterialListJsonBase jsonEntry : this.requirements) {
                outputArr.add(jsonEntry.toJson(ops));
            }
            obj.add("Requirements", (JsonElement)outputArr);
            arr.add((JsonElement)obj);
        }
        return arr;
    }

    public static enum Type {
        LAST,
        EMPTY,
        ONE,
        MULTI;

    }
}

