/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages;

import com.etema.otherstages.commands.StageCommands;
import com.etema.otherstages.core.ConfigManager;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.events.StageEventHandler;
import com.etema.otherstages.integration.RecipeViewerManager;
import com.etema.otherstages.items.ModItems;
import com.etema.otherstages.network.NetworkHandler;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="otherstages")
public class OtherStagesMod {
    public static final String MODID = "otherstages";
    public static final Logger LOGGER = LogManager.getLogger();

    public OtherStagesMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ConfigManager.register();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::onConfigReload);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new StageEventHandler());
        LOGGER.info("OtherStages mod initialized");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("=== COMMON SETUP STARTED ===");
        event.enqueueWork(() -> {
            NetworkHandler.init();
            LOGGER.info("NetworkHandler initialized");
            RecipeViewerManager.init();
            ConfigManager.ensureConfigExists();
            LOGGER.info("Common setup completed");
        });
    }

    @SubscribeEvent
    public void onConfigLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            LOGGER.info("Server configuration loaded: {}", (Object)configEvent.getConfig().getFileName());
            ConfigManager.onConfigLoad();
        }
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            LOGGER.info("Server configuration reloaded: {}", (Object)configEvent.getConfig().getFileName());
            ConfigManager.onConfigReload();
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("=== SERVER STARTING ===");
        StageCommands.register((CommandDispatcher<CommandSourceStack>)event.getServer().m_129892_().m_82094_());
        LOGGER.info("Commands registered");
        ConfigManager.loadAllStages();
        ConfigManager.validateConfiguration();
        int stageCount = StageManager.getAllStages().size();
        LOGGER.info("Server started with {} stages loaded", (Object)stageCount);
        if (stageCount == 0) {
            LOGGER.warn("WARNING! No stages loaded. Mod will not apply restrictions.");
        }
    }
}

