/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.cache;

import com.etema.otherstages.OtherStagesMod;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class StageCache {
    private final Map<String, CacheEntry> itemCache = new ConcurrentHashMap<String, CacheEntry>();
    private final Map<UUID, Long> playerInvalidationTimes = new ConcurrentHashMap<UUID, Long>();
    private final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor();
    private static final long CACHE_DURATION = 300000L;
    private static final long CLEANUP_INTERVAL = 60000L;

    public StageCache() {
        this.cleanupExecutor.scheduleAtFixedRate(this::cleanup, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public String getItemKey(UUID playerId, ItemStack stack) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        String nbtHash = stack.m_41782_() ? String.valueOf(stack.m_41783_().hashCode()) : "0";
        return String.valueOf(playerId) + ":" + String.valueOf(itemId) + ":" + nbtHash;
    }

    public Boolean getItemResult(String key) {
        CacheEntry entry = this.itemCache.get(key);
        if (entry == null) {
            return null;
        }
        if (System.currentTimeMillis() - entry.timestamp > 300000L) {
            this.itemCache.remove(key);
            return null;
        }
        UUID playerId = this.extractPlayerIdFromKey(key);
        Long invalidationTime = this.playerInvalidationTimes.get(playerId);
        if (invalidationTime != null && entry.timestamp < invalidationTime) {
            this.itemCache.remove(key);
            return null;
        }
        return entry.blocked;
    }

    public void cacheItemResult(String key, boolean blocked) {
        this.itemCache.put(key, new CacheEntry(blocked, System.currentTimeMillis()));
    }

    public void invalidatePlayer(UUID playerId) {
        this.playerInvalidationTimes.put(playerId, System.currentTimeMillis());
        this.itemCache.entrySet().removeIf(entry -> this.extractPlayerIdFromKey((String)entry.getKey()).equals(playerId));
    }

    public void invalidateAll() {
        this.itemCache.clear();
        this.playerInvalidationTimes.clear();
    }

    private UUID extractPlayerIdFromKey(String key) {
        try {
            String[] parts = key.split(":", 2);
            return UUID.fromString(parts[0]);
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.warn("Invalid cache key: " + key);
            return UUID.randomUUID();
        }
    }

    private void cleanup() {
        long currentTime = System.currentTimeMillis();
        this.itemCache.entrySet().removeIf(entry -> currentTime - ((CacheEntry)entry.getValue()).timestamp > 300000L);
        this.playerInvalidationTimes.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 600000L);
        if (this.itemCache.size() > 0) {
            OtherStagesMod.LOGGER.debug("Cache stats - Items: {}, Players: {}", (Object)this.itemCache.size(), (Object)this.playerInvalidationTimes.size());
        }
    }

    public void shutdown() {
        this.cleanupExecutor.shutdown();
        try {
            if (!this.cleanupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cleanupExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.cleanupExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public int getCacheSize() {
        return this.itemCache.size();
    }

    public double getHitRate() {
        return 0.0;
    }

    private static class CacheEntry {
        final boolean blocked;
        final long timestamp;

        CacheEntry(boolean blocked, long timestamp) {
            this.blocked = blocked;
            this.timestamp = timestamp;
        }
    }
}

