/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.client.events;

import com.etema.otherstages.integration.RecipeViewerManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherstages", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientRecipeViewerHandler {
    private static Player lastPlayer = null;
    private static int tickCounter = 0;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter % 60 != 0) {
            return;
        }
        LocalPlayer currentPlayer = Minecraft.m_91087_().f_91074_;
        if (currentPlayer != lastPlayer && currentPlayer != null) {
            lastPlayer = currentPlayer;
            ClientRecipeViewerHandler.scheduleRefresh((Player)currentPlayer);
        }
    }

    private static void scheduleRefresh(Player player) {
        new Thread(() -> {
            try {
                Thread.sleep(1500L);
                if (player == Minecraft.m_91087_().f_91074_) {
                    RecipeViewerManager.refreshForPlayer(player);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void onStagesUpdated() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            RecipeViewerManager.onPlayerStagesChanged((Player)player);
        }
    }
}

