/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.client.gui;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherstages", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DimensionWarningOverlay {
    private static boolean showWarning = false;
    private static String dimensionName = "";
    private static String requiredStage = "";
    private static float warningAlpha = 0.0f;
    private static boolean isDimensionBlocked = false;
    private static long warningStartTime = 0L;
    private static int displayDuration = 5000;

    public static void showWarning(String dim, String stage, int seconds) {
        DimensionWarningOverlay.showWarning(dim, stage, seconds, false);
    }

    public static void showWarning(String dim, String stage, int duration, boolean isBlocked) {
        dimensionName = dim;
        requiredStage = stage;
        showWarning = true;
        isDimensionBlocked = isBlocked;
        warningAlpha = 1.0f;
        warningStartTime = System.currentTimeMillis();
        displayDuration = duration > 0 ? duration : 5000;
    }

    public static void hideWarning() {
        showWarning = false;
        warningAlpha = 0.0f;
    }

    public static boolean isShowingWarning() {
        return showWarning;
    }

    public static boolean isDimensionBlocked() {
        return isDimensionBlocked;
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (!showWarning) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - warningStartTime > (long)displayDuration) {
            DimensionWarningOverlay.hideWarning();
            return;
        }
        DimensionWarningOverlay.renderWarningOverlay(event.getGuiGraphics(), mc);
    }

    private static void renderWarningOverlay(GuiGraphics graphics, Minecraft mc) {
        Font font = mc.f_91062_;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        int centerX = screenWidth / 2;
        int startY = (int)((double)screenHeight * 0.25);
        DimensionWarningOverlay.calculateWarningAlpha();
        int alphaValue = (int)(warningAlpha * 255.0f);
        int titleColor = alphaValue << 24 | 0xFF4444;
        int subtitleColor = alphaValue << 24 | 0xFFAA44;
        float titleScale = 2.0f;
        float subtitleScale = 1.2f;
        MutableComponent warningTitle = isDimensionBlocked ? Component.m_237115_((String)"otherstages.dimension_blocked.title_permanent").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}) : Component.m_237115_((String)"otherstages.dimension_blocked.title").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED});
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(titleScale, titleScale, 1.0f);
        graphics.m_280653_(font, (Component)warningTitle, (int)((float)centerX / titleScale), (int)((float)startY / titleScale), titleColor);
        graphics.m_280168_().m_85849_();
        MutableComponent dimensionText = Component.m_237110_((String)"otherstages.dimension_blocked.dimension_label", (Object[])new Object[]{dimensionName}).m_130940_(ChatFormatting.YELLOW);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(subtitleScale, subtitleScale, 1.0f);
        graphics.m_280653_(font, (Component)dimensionText, (int)((float)centerX / subtitleScale), (int)((float)(startY + 40) / subtitleScale), subtitleColor);
        graphics.m_280168_().m_85849_();
        if (requiredStage != null && !requiredStage.isEmpty()) {
            MutableComponent stageText = Component.m_237110_((String)"otherstages.dimension_blocked.stage_required", (Object[])new Object[]{requiredStage}).m_130940_(ChatFormatting.GOLD);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(subtitleScale, subtitleScale, 1.0f);
            graphics.m_280653_(font, (Component)stageText, (int)((float)centerX / subtitleScale), (int)((float)(startY + 65) / subtitleScale), subtitleColor);
            graphics.m_280168_().m_85849_();
            startY += 90;
        } else {
            startY += 65;
        }
        DimensionWarningOverlay.renderStatusMessage(graphics, font, centerX, startY, alphaValue, subtitleScale);
    }

    private static void renderStatusMessage(GuiGraphics graphics, Font font, int centerX, int startY, int alphaValue, float subtitleScale) {
        int messageColor;
        MutableComponent statusMessage;
        if (isDimensionBlocked) {
            statusMessage = Component.m_237115_((String)"otherstages.dimension_blocked.permanently_blocked").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD});
            messageColor = alphaValue << 24 | 0xAA0000;
        } else {
            statusMessage = Component.m_237115_((String)"otherstages.dimension_blocked.leave_area").m_130940_(ChatFormatting.YELLOW);
            messageColor = alphaValue << 24 | 0xFFDD00;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(subtitleScale, subtitleScale, 1.0f);
        graphics.m_280653_(font, (Component)statusMessage, (int)((float)centerX / subtitleScale), (int)((float)startY / subtitleScale), messageColor);
        graphics.m_280168_().m_85849_();
    }

    private static void calculateWarningAlpha() {
        warningAlpha = isDimensionBlocked ? 0.8f + 0.2f * (float)Math.sin((double)System.currentTimeMillis() * 0.005) : 1.0f;
    }
}

