/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.client.gui;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherstages", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StructureWarningOverlay {
    private static boolean showWarning = false;
    private static String structureName = "";
    private static String requiredStage = "";
    private static int remainingSeconds = 0;
    private static long lastUpdateTime = 0L;
    private static float warningAlpha = 0.0f;
    private static boolean isAccessDenied = false;

    public static void showWarning(String structure, String stage, int seconds) {
        StructureWarningOverlay.showWarning(structure, stage, seconds, false);
    }

    public static void showWarning(String structure, String stage, int seconds, boolean accessDenied) {
        showWarning = true;
        structureName = structure;
        requiredStage = stage;
        remainingSeconds = seconds;
        lastUpdateTime = System.currentTimeMillis();
        warningAlpha = 1.0f;
        isAccessDenied = accessDenied;
    }

    public static void hideWarning() {
        showWarning = false;
        warningAlpha = 0.0f;
        isAccessDenied = false;
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        if (!showWarning) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.m_91104_()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - lastUpdateTime) / 1000.0f;
        lastUpdateTime = currentTime;
        warningAlpha = isAccessDenied ? (float)(0.7 + 0.3 * Math.sin((double)currentTime / 400.0)) : (remainingSeconds <= 2 ? (float)(0.5 + 0.5 * Math.sin((double)currentTime / 200.0)) : Math.min(1.0f, warningAlpha + deltaTime * 2.0f));
        StructureWarningOverlay.renderWarningOverlay(event.getGuiGraphics(), mc);
    }

    private static void renderWarningOverlay(GuiGraphics graphics, Minecraft mc) {
        MutableComponent instructionText;
        MutableComponent warningTitle;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        Font font = mc.f_91062_;
        int borderAlpha = (int)(255.0f * warningAlpha);
        int borderColor = borderAlpha << 24 | 0xFF0000;
        int borderThickness = (int)(3.0 + 2.0 * Math.sin((double)System.currentTimeMillis() / 300.0));
        graphics.m_280509_(0, 0, screenWidth, borderThickness, borderColor);
        graphics.m_280509_(0, screenHeight - borderThickness, screenWidth, screenHeight, borderColor);
        graphics.m_280509_(0, 0, borderThickness, screenHeight, borderColor);
        graphics.m_280509_(screenWidth - borderThickness, 0, screenWidth, screenHeight, borderColor);
        if (isAccessDenied) {
            warningTitle = Component.m_237115_((String)"otherstages.structure_blocked.ui.access_denied").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD});
            instructionText = Component.m_237115_((String)"otherstages.structure_blocked.ui.access_denied_instruction").m_130940_(ChatFormatting.YELLOW);
        } else {
            warningTitle = Component.m_237115_((String)"otherstages.structure_blocked.ui.title").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
            instructionText = Component.m_237115_((String)"otherstages.structure_blocked.ui.instruction").m_130940_(ChatFormatting.YELLOW);
        }
        MutableComponent structureText = Component.m_237110_((String)"otherstages.structure_blocked.ui.structure", (Object[])new Object[]{StructureWarningOverlay.formatStructureName(structureName)});
        MutableComponent stageText = Component.m_237110_((String)"otherstages.structure_blocked.ui.required_stage", (Object[])new Object[]{requiredStage});
        MutableComponent timerText = Component.m_237110_((String)"otherstages.structure_blocked.ui.timer", (Object[])new Object[]{remainingSeconds});
        int centerX = screenWidth / 2;
        int startY = screenHeight / 3;
        int lineHeight = 20;
        float titleScale = 2.0f;
        float textScale = 1.2f;
        float timerScale = 1.8f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(titleScale, titleScale, 1.0f);
        int titleWidth = font.m_92852_((FormattedText)warningTitle);
        graphics.m_280653_(font, (Component)warningTitle, (int)((float)centerX / titleScale), (int)((float)startY / titleScale), 0xFFFFFF);
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(textScale, textScale, 1.0f);
        graphics.m_280653_(font, (Component)structureText, (int)((float)centerX / textScale), (int)((float)(startY += (int)((float)lineHeight * titleScale) + 10) / textScale), 0xFFFFFF);
        graphics.m_280168_().m_85849_();
        startY += (int)((float)lineHeight * textScale);
        if (requiredStage != null && !requiredStage.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(textScale, textScale, 1.0f);
            graphics.m_280653_(font, (Component)stageText, (int)((float)centerX / textScale), (int)((float)startY / textScale), 0xFFDD00);
            graphics.m_280168_().m_85849_();
            startY += (int)((float)lineHeight * textScale);
        }
        startY += 20;
        if (!isAccessDenied && remainingSeconds > 0) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(timerScale, timerScale, 1.0f);
            int timerColor = remainingSeconds <= 2 ? 0xFF4444 : 0xFF8888;
            graphics.m_280653_(font, (Component)timerText, (int)((float)centerX / timerScale), (int)((float)startY / timerScale), timerColor);
            graphics.m_280168_().m_85849_();
            startY += (int)((float)lineHeight * timerScale) + 20;
        } else if (isAccessDenied) {
            float deniedScale = 1.5f;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(deniedScale, deniedScale, 1.0f);
            MutableComponent deniedMessage = Component.m_237115_((String)"otherstages.structure_blocked.ui.permanently_blocked").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD});
            graphics.m_280653_(font, (Component)deniedMessage, (int)((float)centerX / deniedScale), (int)((float)startY / deniedScale), 0xFF4444);
            graphics.m_280168_().m_85849_();
            startY += (int)((float)lineHeight * deniedScale) + 20;
        }
        graphics.m_280653_(font, (Component)instructionText, centerX, startY, 0xFFFFAA);
        graphics.m_280168_().m_85849_();
        StructureWarningOverlay.renderWarningIcons(graphics, screenWidth, screenHeight, warningAlpha);
    }

    private static void renderWarningIcons(GuiGraphics graphics, int screenWidth, int screenHeight, float alpha) {
        int iconAlpha = (int)(255.0f * alpha);
        int iconColor = iconAlpha << 24 | 0xFFFF00;
        String warningSymbol = "\u26a0";
        Font font = Minecraft.m_91087_().f_91062_;
        int offset = 20;
        float iconScale = 2.0f;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(iconScale, iconScale, 1.0f);
        graphics.m_280488_(font, warningSymbol, (int)((float)offset / iconScale), (int)((float)offset / iconScale), iconColor);
        int rightX = (int)(((float)(screenWidth - offset) - (float)font.m_92895_(warningSymbol) * iconScale) / iconScale);
        graphics.m_280488_(font, warningSymbol, rightX, (int)((float)offset / iconScale), iconColor);
        float f = screenHeight - offset;
        Objects.requireNonNull(font);
        int bottomY = (int)((f - 9.0f * iconScale) / iconScale);
        graphics.m_280488_(font, warningSymbol, (int)((float)offset / iconScale), bottomY, iconColor);
        graphics.m_280488_(font, warningSymbol, rightX, bottomY, iconColor);
        graphics.m_280168_().m_85849_();
    }

    private static String formatStructureName(String name) {
        if (name == null || name.isEmpty()) {
            return Component.m_237115_((String)"otherstages.structure.unknown").getString();
        }
        String translationKey = "otherstages.structure." + name.replace(":", ".");
        MutableComponent translated = Component.m_237115_((String)translationKey);
        if (!translated.getString().equals(translationKey)) {
            return translated.getString();
        }
        return Arrays.stream(name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }
}

