/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.commands;

import com.etema.otherstages.core.StageManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DimensionCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"otherstages").requires(source -> source.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(DimensionCommands::checkDimensionAccess))))).then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(DimensionCommands::listBlockedDimensions)))));
    }

    private static int checkDimensionAccess(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"dimension");
        ResourceLocation dimensionId = dimension.m_46472_().m_135782_();
        boolean canAccess = StageManager.canAccessDimension((Player)player, dimensionId);
        String requiredStage = StageManager.getRequiredStageForDimension((Player)player, dimensionId);
        if (canAccess) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.dimension.can_access", (Object[])new Object[]{player.m_5446_().getString(), dimensionId.toString()}).m_130940_(ChatFormatting.GREEN), false);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.dimension.cannot_access", (Object[])new Object[]{player.m_5446_().getString(), dimensionId.toString(), requiredStage != null ? requiredStage : "Unknown"}).m_130940_(ChatFormatting.RED), false);
        }
        return 1;
    }

    private static int listBlockedDimensions(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.dimension.blocked_list_header", (Object[])new Object[]{player.m_5446_().getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        ResourceLocation[] commonDimensions = new ResourceLocation[]{new ResourceLocation("minecraft:overworld"), new ResourceLocation("minecraft:the_nether"), new ResourceLocation("minecraft:the_end")};
        boolean foundBlocked = false;
        for (ResourceLocation dimension : commonDimensions) {
            if (StageManager.canAccessDimension((Player)player, dimension)) continue;
            String requiredStage = StageManager.getRequiredStageForDimension((Player)player, dimension);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  \u2022 " + dimension.toString() + " - Requires: " + (requiredStage != null ? requiredStage : "Unknown"))).m_130940_(ChatFormatting.RED), false);
            foundBlocked = true;
        }
        if (!foundBlocked) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.dimension.no_blocked").m_130940_(ChatFormatting.GREEN), false);
        }
        return 1;
    }
}

