/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.commands;

import com.etema.otherstages.core.ConfigManager;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.data.PlayerStageData;
import com.etema.otherstages.data.StageDefinition;
import com.etema.otherstages.progression.StageProgressionSystem;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class StageCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"otherstages").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"check").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(StageCommands::checkProgression)))).then(Commands.m_82127_((String)"player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"info").executes(StageCommands::showPlayerStages))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            StageManager.getAllStages().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(StageCommands::grantStage)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"stage", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            try {
                ServerPlayer player = EntityArgument.m_91474_((CommandContext)context, (String)"target");
                StageManager.getPlayerStages((Player)player).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return builder.buildFuture();
        }).executes(StageCommands::removeStage)))).then(Commands.m_82127_((String)"clear").executes(StageCommands::clearPlayerStages))).then(Commands.m_82127_((String)"reset").executes(StageCommands::resetPlayerProgression))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"stage").then(Commands.m_82127_((String)"list").executes(StageCommands::listAllStages))).then(Commands.m_82129_((String)"stage_name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            StageManager.getAllStages().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(Commands.m_82127_((String)"info").executes(StageCommands::showStageInfo))))).then(Commands.m_82127_((String)"reload").executes(StageCommands::reloadStages))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"cache").then(Commands.m_82127_((String)"clear").executes(StageCommands::clearCache))).then(Commands.m_82127_((String)"info").executes(StageCommands::showCacheInfo)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"item").executes(StageCommands::debugHeldItem))).then(Commands.m_82127_((String)"stages").executes(StageCommands::debugPlayerStages))));
    }

    private static int showPlayerStages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        PlayerStageData data = StageManager.getPlayerData((Player)target);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.player_info.header", (Object[])new Object[]{target.m_5446_().getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        Set<String> stages = data.getUnlockedStages();
        if (stages.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.player_info.no_stages").m_130940_(ChatFormatting.RED), false);
        } else {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.player_info.unlocked_stages", (Object[])new Object[]{stages.size()}).m_130940_(ChatFormatting.GREEN), false);
            List sortedStages = stages.stream().sorted((a, b) -> {
                StageDefinition stageA = StageManager.getStage(a);
                StageDefinition stageB = StageManager.getStage(b);
                if (stageA == null || stageB == null) {
                    return a.compareTo((String)b);
                }
                return Integer.compare(stageA.getOrder(), stageB.getOrder());
            }).collect(Collectors.toList());
            for (String stage : sortedStages) {
                StageDefinition def = StageManager.getStage(stage);
                String displayName = def != null ? def.getTranslatableDisplayName().getString() : stage;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  \u2022 " + displayName + " (" + stage + ")")).m_130940_(ChatFormatting.YELLOW), false);
            }
        }
        String currentStage = data.getCurrentStage();
        if (currentStage != null) {
            StageDefinition def = StageManager.getStage(currentStage);
            String displayName = def != null ? def.getTranslatableDisplayName().getString() : currentStage;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.player_info.current_stage", (Object[])new Object[]{displayName}).m_130940_(ChatFormatting.AQUA), false);
        }
        return 1;
    }

    private static int grantStage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        String stageName = StringArgumentType.getString(context, (String)"stage");
        if (!StageManager.getAllStages().contains(stageName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"otherstages.commands.stage.not_exist", (Object[])new Object[]{stageName}));
            return 0;
        }
        if (StageManager.hasStage((Player)target, stageName)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"otherstages.commands.stage.already_has", (Object[])new Object[]{stageName}));
            return 0;
        }
        StageManager.grantStage((Player)target, stageName);
        StageDefinition def = StageManager.getStage(stageName);
        String displayName = def != null ? def.getTranslatableDisplayName().getString() : stageName;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage.granted", (Object[])new Object[]{displayName, target.m_5446_().getString()}).m_130940_(ChatFormatting.GREEN), true);
        target.m_213846_((Component)Component.m_237110_((String)"otherstages.commands.stage.unlocked_notification", (Object[])new Object[]{displayName}).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
        return 1;
    }

    private static int removeStage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String stageName;
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        if (!StageManager.hasStage((Player)target, stageName = StringArgumentType.getString(context, (String)"stage"))) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"otherstages.commands.stage.not_have", (Object[])new Object[]{stageName}));
            return 0;
        }
        StageManager.removeStage((Player)target, stageName);
        StageDefinition def = StageManager.getStage(stageName);
        String displayName = def != null ? def.getTranslatableDisplayName().getString() : stageName;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage.removed", (Object[])new Object[]{displayName, target.m_5446_().getString()}).m_130940_(ChatFormatting.YELLOW), true);
        return 1;
    }

    private static int clearPlayerStages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        PlayerStageData data = StageManager.getPlayerData((Player)target);
        HashSet<String> stages = new HashSet<String>(data.getUnlockedStages());
        for (String stage : stages) {
            StageManager.removeStage((Player)target, stage);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage.cleared", (Object[])new Object[]{target.m_5446_().getString()}).m_130940_(ChatFormatting.YELLOW), true);
        return 1;
    }

    private static int resetPlayerProgression(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"target");
        StageCommands.clearPlayerStages(context);
        String startingStage = "stone_age";
        if (StageManager.getAllStages().contains(startingStage)) {
            StageManager.grantStage((Player)target, startingStage);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage.reset", (Object[])new Object[]{target.m_5446_().getString()}).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int listAllStages(CommandContext<CommandSourceStack> context) {
        Collection<StageDefinition> stages = StageManager.getAllStageDefinitions();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.list.header").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        if (stages.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.list.no_stages").m_130940_(ChatFormatting.RED), false);
        } else {
            List sortedStages = stages.stream().sorted(Comparator.comparingInt(StageDefinition::getOrder)).collect(Collectors.toList());
            for (StageDefinition stage : sortedStages) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.list.stage_format", (Object[])new Object[]{stage.getOrder(), stage.getTranslatableDisplayName().getString(), stage.getName()}).m_130940_(ChatFormatting.YELLOW), false);
                String description = stage.getTranslatableDescription().getString();
                if (description == null || description.isEmpty()) continue;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("     " + description)).m_130940_(ChatFormatting.GRAY), false);
            }
        }
        return 1;
    }

    private static int showStageInfo(CommandContext<CommandSourceStack> context) {
        String stageName = StringArgumentType.getString(context, (String)"stage_name");
        StageDefinition stage = StageManager.getStage(stageName);
        if (stage == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"otherstages.commands.stage_info.not_found", (Object[])new Object[]{stageName}));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage_info.header", (Object[])new Object[]{stage.getTranslatableDisplayName().getString()}).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage_info.internal_name", (Object[])new Object[]{stage.getName()}).m_130940_(ChatFormatting.GRAY), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage_info.order", (Object[])new Object[]{stage.getOrder()}).m_130940_(ChatFormatting.GRAY), false);
        String description = stage.getTranslatableDescription().getString();
        if (description != null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage_info.description", (Object[])new Object[]{description}).m_130940_(ChatFormatting.WHITE), false);
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.stage_info.color", (Object[])new Object[]{stage.getColor()}).m_130940_(ChatFormatting.GRAY), false);
        return 1;
    }

    private static int reloadStages(CommandContext<CommandSourceStack> context) {
        try {
            ConfigManager.loadAllStages();
            int stageCount = StageManager.getAllStages().size();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.reload.success", (Object[])new Object[]{stageCount}).m_130940_(ChatFormatting.GREEN), true);
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"otherstages.commands.reload.failed", (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
        return 1;
    }

    private static int clearCache(CommandContext<CommandSourceStack> context) {
        StageManager.clearCache();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.cache.cleared").m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int showCacheInfo(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.cache.info_not_implemented").m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int debugHeldItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CompoundTag nbt;
        String requiredStage;
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"otherstages.commands.players_only"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41619_()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"otherstages.commands.must_hold_item"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"otherstages.commands.debug.header").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), false);
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)heldItem.m_41720_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.debug.item", (Object[])new Object[]{itemId}).m_130940_(ChatFormatting.WHITE), false);
        boolean isBlocked = StageManager.isItemBlocked((Player)player, heldItem);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.debug.blocked", (Object[])new Object[]{Component.m_237115_((String)(isBlocked ? "otherstages.commands.debug.blocked_yes" : "otherstages.commands.debug.blocked_no"))}).m_130940_(isBlocked ? ChatFormatting.RED : ChatFormatting.GREEN), false);
        if (isBlocked && (requiredStage = StageManager.getRequiredStage((Player)player, heldItem)) != null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.debug.required_stage", (Object[])new Object[]{requiredStage}).m_130940_(ChatFormatting.YELLOW), false);
        }
        if ((nbt = heldItem.m_41783_()) != null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.debug.nbt", (Object[])new Object[]{nbt.toString()}).m_130940_(ChatFormatting.GRAY), false);
        }
        return 1;
    }

    private static int debugPlayerStages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"otherstages.commands.players_only"));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        return StageCommands.showPlayerStages(context);
    }

    private static int checkProgression(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.m_91474_(context, (String)"player");
        StageProgressionSystem.forceCheckProgression((Player)target);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"otherstages.commands.progression.checked", (Object[])new Object[]{target.m_5446_().getString()}).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }
}

