/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.config;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.data.BlockedItem;
import com.etema.otherstages.data.StageDefinition;
import com.etema.otherstages.progression.ProgressionCondition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;

public class JsonLoader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadAllStages(Path stagesDir) {
        if (!Files.exists(stagesDir, new LinkOption[0])) {
            OtherStagesMod.LOGGER.warn("Stages directory does not exist: {}", (Object)stagesDir);
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(stagesDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Path stageDir : stream) {
                JsonLoader.loadSingleStage(stageDir);
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load stages from directory: {}", (Object)stagesDir, (Object)e);
        }
    }

    private static void loadSingleStage(Path stageDir) {
        String stageName = stageDir.getFileName().toString();
        try {
            Path stageInfoPath = stageDir.resolve("stage_info.json");
            if (!Files.exists(stageInfoPath, new LinkOption[0])) {
                OtherStagesMod.LOGGER.warn("Missing stage_info.json for stage: {}", (Object)stageName);
                return;
            }
            StageDefinition stage = JsonLoader.loadStageInfo(stageInfoPath, stageName);
            JsonLoader.loadBlockedItems(stageDir.resolve("blocked_items.json"), stage);
            JsonLoader.loadBlockedMobs(stageDir.resolve("blocked_mobs.json"), stage);
            JsonLoader.loadBlockedStructures(stageDir.resolve("blocked_structures.json"), stage);
            JsonLoader.loadBlockedDimensions(stageDir.resolve("blocked_dimensions.json"), stage);
            JsonLoader.loadBlockedLoot(stageDir.resolve("blocked_loot.json"), stage);
            JsonLoader.loadProgression(stageDir.resolve("progression.json"), stage);
            StageManager.registerStage(stageName, stage);
            OtherStagesMod.LOGGER.info("Loaded stage: {} ({})", (Object)stage.getDisplayName(), (Object)stageName);
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Failed to load stage: {}", (Object)stageName, (Object)e);
        }
    }

    private static StageDefinition loadStageInfo(Path stageInfoPath, String stageName) throws IOException {
        JsonObject json = JsonLoader.loadJsonFile(stageInfoPath);
        StageDefinition stage = new StageDefinition(stageName);
        if (json.has("display_name")) {
            stage.setDisplayName(json.get("display_name").getAsString());
        } else {
            String formattedName = JsonLoader.formatStageName(stageName);
            stage.setDisplayName(formattedName);
        }
        if (json.has("description")) {
            stage.setDescription(json.get("description").getAsString());
        }
        if (json.has("color")) {
            stage.setColor(json.get("color").getAsString());
        }
        if (json.has("icon")) {
            stage.setIcon(new ResourceLocation(json.get("icon").getAsString()));
        }
        if (json.has("order")) {
            stage.setOrder(json.get("order").getAsInt());
        }
        return stage;
    }

    private static String formatStageName(String stageName) {
        return Arrays.stream(stageName.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    private static void loadBlockedItems(Path filePath, StageDefinition stage) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject json = JsonLoader.loadJsonFile(filePath);
            if (json.has("blocked_items")) {
                JsonArray items = json.getAsJsonArray("blocked_items");
                for (JsonElement element : items) {
                    JsonObject itemObj = element.getAsJsonObject();
                    ResourceLocation itemId = new ResourceLocation(itemObj.get("item").getAsString());
                    CompoundTag nbtPattern = null;
                    if (itemObj.has("nbt")) {
                        try {
                            JsonElement nbtElement = itemObj.get("nbt");
                            String nbtString = JsonLoader.convertJsonToNbt(nbtElement);
                            nbtPattern = TagParser.m_129359_((String)nbtString);
                        }
                        catch (Exception e) {
                            OtherStagesMod.LOGGER.error("Failed to parse NBT for item: {}", (Object)itemId, (Object)e);
                            continue;
                        }
                    }
                    boolean exactMatch = itemObj.has("exact_match") && itemObj.get("exact_match").getAsBoolean();
                    stage.addBlockedItem(new BlockedItem(itemId, nbtPattern, exactMatch));
                }
            }
            if (json.has("blocked_tags") || json.has("tagList")) {
                JsonArray tags = json.has("blocked_tags") ? json.getAsJsonArray("blocked_tags") : json.getAsJsonArray("tagList");
                for (JsonElement element : tags) {
                    String tagName = element.getAsString();
                    stage.addBlockedTag(new ResourceLocation(tagName));
                }
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load blocked items for stage: {}", (Object)stage.getName(), (Object)e);
        }
    }

    private static void loadBlockedMobs(Path filePath, StageDefinition stage) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject json = JsonLoader.loadJsonFile(filePath);
            if (!json.has("blocked_mobs")) {
                return;
            }
            JsonArray mobs = json.getAsJsonArray("blocked_mobs");
            for (JsonElement element : mobs) {
                ResourceLocation mobId = new ResourceLocation(element.getAsString());
                stage.addBlockedMob(mobId);
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load blocked mobs for stage: {}", (Object)stage.getName(), (Object)e);
        }
    }

    private static void loadBlockedStructures(Path filePath, StageDefinition stage) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject json = JsonLoader.loadJsonFile(filePath);
            if (!json.has("blocked_structures")) {
                return;
            }
            JsonArray structures = json.getAsJsonArray("blocked_structures");
            for (JsonElement element : structures) {
                ResourceLocation structureId = new ResourceLocation(element.getAsString());
                stage.addBlockedStructure(structureId);
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load blocked structures for stage: {}", (Object)stage.getName(), (Object)e);
        }
    }

    private static void loadBlockedDimensions(Path filePath, StageDefinition stage) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject json = JsonLoader.loadJsonFile(filePath);
            if (!json.has("blocked_dimensions")) {
                return;
            }
            JsonArray dimensions = json.getAsJsonArray("blocked_dimensions");
            for (JsonElement element : dimensions) {
                ResourceLocation dimensionId = new ResourceLocation(element.getAsString());
                stage.addBlockedDimension(dimensionId);
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load blocked dimensions for stage: {}", (Object)stage.getName(), (Object)e);
        }
    }

    private static void loadBlockedLoot(Path filePath, StageDefinition stage) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject json = JsonLoader.loadJsonFile(filePath);
            if (!json.has("blocked_loot")) {
                return;
            }
            JsonArray loot = json.getAsJsonArray("blocked_loot");
            for (JsonElement element : loot) {
                ResourceLocation lootId = new ResourceLocation(element.getAsString());
                stage.addBlockedLoot(lootId);
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load blocked loot for stage: {}", (Object)stage.getName(), (Object)e);
        }
    }

    private static void loadProgression(Path filePath, StageDefinition stage) {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject json = JsonLoader.loadJsonFile(filePath);
            if (json.has("unlock_conditions")) {
                JsonObject conditionsJson = json.getAsJsonObject("unlock_conditions");
                ProgressionCondition condition = JsonLoader.parseProgressionCondition(conditionsJson);
                stage.setUnlockCondition(condition);
            }
            if (json.has("next_stage") && !json.get("next_stage").isJsonNull()) {
                stage.setNextStage(json.get("next_stage").getAsString());
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Failed to load progression for stage: {}", (Object)stage.getName(), (Object)e);
        }
    }

    private static ProgressionCondition parseProgressionCondition(JsonObject json) {
        String type = json.get("type").getAsString();
        switch (type.toLowerCase()) {
            case "and": {
                ArrayList<ProgressionCondition> andConditions = new ArrayList<ProgressionCondition>();
                JsonArray andArray = json.getAsJsonArray("conditions");
                for (JsonElement element : andArray) {
                    andConditions.add(JsonLoader.parseProgressionCondition(element.getAsJsonObject()));
                }
                return new ProgressionCondition.AndCondition(andConditions);
            }
            case "or": {
                ArrayList<ProgressionCondition> orConditions = new ArrayList<ProgressionCondition>();
                JsonArray orArray = json.getAsJsonArray("conditions");
                for (JsonElement element : orArray) {
                    orConditions.add(JsonLoader.parseProgressionCondition(element.getAsJsonObject()));
                }
                return new ProgressionCondition.OrCondition(orConditions);
            }
            case "advancement": {
                ResourceLocation advancement = new ResourceLocation(json.get("advancement").getAsString());
                return new ProgressionCondition.AdvancementCondition(advancement);
            }
            case "item_count": {
                ResourceLocation itemId = new ResourceLocation(json.get("item").getAsString());
                int count = json.get("count").getAsInt();
                boolean consume = json.has("consume") ? json.get("consume").getAsBoolean() : false;
                return new ProgressionCondition.ItemCountCondition(itemId, count, consume);
            }
            case "experience": {
                int level = json.get("level").getAsInt();
                boolean consumeLevels = json.has("consume") ? json.get("consume").getAsBoolean() : false;
                return new ProgressionCondition.ExperienceLevelCondition(level, consumeLevels);
            }
            case "dimension": {
                ResourceLocation dimension = new ResourceLocation(json.get("dimension").getAsString());
                return new ProgressionCondition.DimensionCondition(dimension);
            }
            case "kill_count": {
                ResourceLocation entityType = new ResourceLocation(json.get("entity").getAsString());
                int kills = json.get("count").getAsInt();
                return new ProgressionCondition.KillCountCondition(entityType, kills);
            }
            case "craft_count": {
                ResourceLocation craftItem = new ResourceLocation(json.get("item").getAsString());
                int crafts = json.get("count").getAsInt();
                return new ProgressionCondition.CraftCountCondition(craftItem, crafts);
            }
        }
        throw new IllegalArgumentException("Unknown progression condition type: " + type);
    }

    private static JsonObject loadJsonFile(Path filePath) throws IOException {
        try (FileReader reader = new FileReader(filePath.toFile());){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            return jsonObject;
        }
    }

    private static String convertJsonToNbt(JsonElement element) {
        return element.toString();
    }
}

