/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.core;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.config.JsonLoader;
import com.etema.otherstages.core.StageManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static final ForgeConfigSpec.BooleanValue ENABLE_STAGE_MODE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TOOLTIPS;
    public static final ForgeConfigSpec.BooleanValue ENABLE_WARNINGS;
    public static final ForgeConfigSpec.IntValue WARNING_DURATION;
    public static final ForgeConfigSpec.BooleanValue TELEPORT_ON_INVALID_DIMENSION;
    public static final ForgeConfigSpec.ConfigValue<String> DEFAULT_STARTING_STAGE;
    public static final ForgeConfigSpec.BooleanValue ENABLE_DEBUG_LOGGING;
    public static final ForgeConfigSpec.IntValue CACHE_SIZE;

    public static void register() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG, "otherstages-server.toml");
        OtherStagesMod.LOGGER.info("Configuration registered: otherstages-server.toml");
    }

    public static void ensureConfigExists() {
        Path configFile = FMLPaths.CONFIGDIR.get().resolve("otherstages-server.toml");
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                CommentedFileConfig fileConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile).sync().autosave().build();
                CONFIG.setConfig((CommentedConfig)fileConfig);
                fileConfig.save();
                fileConfig.close();
                OtherStagesMod.LOGGER.info("Configuration file created: {}", (Object)configFile);
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.error("Error creating configuration file", (Throwable)e);
            }
        } else {
            OtherStagesMod.LOGGER.info("Configuration file already exists: {}", (Object)configFile);
        }
    }

    private static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("otherstages");
    }

    private static Path getStagesPath() {
        return ConfigManager.getConfigPath().resolve("stages");
    }

    public static void loadAllStages() {
        Path configPath = ConfigManager.getConfigPath();
        Path stagesPath = ConfigManager.getStagesPath();
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath, new FileAttribute[0]);
                OtherStagesMod.LOGGER.info("OtherStages config directory created");
            }
            if (!Files.exists(stagesPath, new LinkOption[0])) {
                Files.createDirectories(stagesPath, new FileAttribute[0]);
                ConfigManager.createExampleStages();
                OtherStagesMod.LOGGER.info("Example stage configurations created");
            }
            JsonLoader.loadAllStages(stagesPath);
            int stageCount = StageManager.getAllStages().size();
            OtherStagesMod.LOGGER.info("Loaded {} stages successfully", (Object)stageCount);
            if (stageCount == 0) {
                OtherStagesMod.LOGGER.warn("No stages were loaded! Check your configuration files.");
            }
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to load stages configuration", (Throwable)e);
        }
    }

    private static void createExampleStages() {
        try {
            ConfigManager.createStoneAgeExample();
            ConfigManager.createIronAgeExample();
            ConfigManager.createDiamondAgeExample();
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to create example stage configurations", (Throwable)e);
        }
    }

    private static void createStoneAgeExample() throws IOException {
        Path stoneAgePath = ConfigManager.getStagesPath().resolve("stone_age");
        Files.createDirectories(stoneAgePath, new FileAttribute[0]);
        String stageInfo = "{\n    \"display_name\": \"Stone Age\",\n    \"color\": \"#8B4513\",\n    \"icon\": \"minecraft:stone_pickaxe\",\n    \"order\": 1\n}";
        Files.writeString(stoneAgePath.resolve("stage_info.json"), (CharSequence)stageInfo, new OpenOption[0]);
        String blockedItems = "{\n    \"blocked_items\": [\n        {\"item\": \"minecraft:iron_pickaxe\"},\n        {\"item\": \"minecraft:iron_axe\"},\n        {\"item\": \"minecraft:iron_sword\"},\n        {\"item\": \"minecraft:diamond_pickaxe\"},\n        {\"item\": \"minecraft:diamond_axe\"},\n        {\"item\": \"minecraft:diamond_sword\"}\n    ]\n}";
        Files.writeString(stoneAgePath.resolve("blocked_items.json"), (CharSequence)blockedItems, new OpenOption[0]);
        String progression = "{\n    \"unlock_conditions\": {\n        \"type\": \"AND\",\n        \"conditions\": [\n            {\"type\": \"advancement\", \"advancement\": \"minecraft:story/mine_stone\"},\n            {\"type\": \"item_count\", \"item\": \"minecraft:cobblestone\", \"count\": 64}\n        ]\n    },\n    \"next_stage\": \"iron_age\"\n}";
        Files.writeString(stoneAgePath.resolve("progression.json"), (CharSequence)progression, new OpenOption[0]);
    }

    private static void createIronAgeExample() throws IOException {
        Path ironAgePath = ConfigManager.getStagesPath().resolve("iron_age");
        Files.createDirectories(ironAgePath, new FileAttribute[0]);
        String stageInfo = "{\n    \"display_name\": \"Iron Age\",\n    \"color\": \"#C0C0C0\",\n    \"icon\": \"minecraft:iron_pickaxe\",\n    \"order\": 2\n}";
        Files.writeString(ironAgePath.resolve("stage_info.json"), (CharSequence)stageInfo, new OpenOption[0]);
        String blockedItems = "{\n    \"blocked_items\": [\n        {\"item\": \"minecraft:diamond_pickaxe\"},\n        {\"item\": \"minecraft:diamond_axe\"},\n        {\"item\": \"minecraft:diamond_sword\"},\n        {\"item\": \"minecraft:netherite_pickaxe\"},\n        {\"item\": \"minecraft:netherite_axe\"},\n        {\"item\": \"minecraft:netherite_sword\"}\n    ]\n}";
        Files.writeString(ironAgePath.resolve("blocked_items.json"), (CharSequence)blockedItems, new OpenOption[0]);
        String progression = "{\n    \"unlock_conditions\": {\n        \"type\": \"advancement\",\n        \"advancement\": \"minecraft:story/smelt_iron\"\n    },\n    \"next_stage\": \"diamond_age\"\n}";
        Files.writeString(ironAgePath.resolve("progression.json"), (CharSequence)progression, new OpenOption[0]);
    }

    private static void createDiamondAgeExample() throws IOException {
        Path diamondAgePath = ConfigManager.getStagesPath().resolve("diamond_age");
        Files.createDirectories(diamondAgePath, new FileAttribute[0]);
        String stageInfo = "{\n    \"display_name\": \"Diamond Age\",\n    \"color\": \"#00FFFF\",\n    \"icon\": \"minecraft:diamond_pickaxe\",\n    \"order\": 3\n}";
        Files.writeString(diamondAgePath.resolve("stage_info.json"), (CharSequence)stageInfo, new OpenOption[0]);
        String progression = "{\n    \"unlock_conditions\": {\n        \"type\": \"advancement\",\n        \"advancement\": \"minecraft:story/mine_diamond\"\n    },\n    \"next_stage\": null\n}";
        Files.writeString(diamondAgePath.resolve("progression.json"), (CharSequence)progression, new OpenOption[0]);
    }

    public static void validateConfiguration() {
        String defaultStage;
        OtherStagesMod.LOGGER.info("Validating configuration...");
        if (!((Boolean)ENABLE_STAGE_MODE.get()).booleanValue()) {
            OtherStagesMod.LOGGER.warn("Stage mode is disabled - all restrictions will be bypassed");
        }
        if (!(defaultStage = (String)DEFAULT_STARTING_STAGE.get()).isEmpty() && !StageManager.getAllStages().contains(defaultStage)) {
            OtherStagesMod.LOGGER.error("Default starting stage '{}' does not exist!", (Object)defaultStage);
        }
        OtherStagesMod.LOGGER.info("Configuration validation completed");
    }

    public static void onConfigLoad() {
        OtherStagesMod.LOGGER.info("=== CONFIGURATION LOADED ===");
        ConfigManager.logConfigurationValues();
    }

    public static void onConfigReload() {
        OtherStagesMod.LOGGER.info("=== CONFIGURATION RELOADED ===");
        ConfigManager.logConfigurationValues();
        StageManager.clearCache();
        if (((Boolean)ENABLE_STAGE_MODE.get()).booleanValue()) {
            ConfigManager.loadAllStages();
        }
    }

    private static void logConfigurationValues() {
        OtherStagesMod.LOGGER.info("Stage Mode Enabled: {}", ENABLE_STAGE_MODE.get());
        OtherStagesMod.LOGGER.info("Tooltips Enabled: {}", ENABLE_TOOLTIPS.get());
        OtherStagesMod.LOGGER.info("Warnings Enabled: {}", ENABLE_WARNINGS.get());
        OtherStagesMod.LOGGER.info("Auto Teleport: {}", TELEPORT_ON_INVALID_DIMENSION.get());
        OtherStagesMod.LOGGER.info("Default Starting Stage: {}", DEFAULT_STARTING_STAGE.get());
    }

    static {
        BUILDER.comment("=== OtherStages Configuration ===");
        BUILDER.push("General");
        ENABLE_STAGE_MODE = BUILDER.comment("Enable the stage progression system").define("enableStageMode", true);
        ENABLE_DEBUG_LOGGING = BUILDER.comment("Enable debug logging for troubleshooting").define("enableDebugLogging", false);
        DEFAULT_STARTING_STAGE = BUILDER.comment("Default stage for new players").define("defaultStartingStage", (Object)"stone_age");
        BUILDER.pop();
        BUILDER.push("User Interface");
        ENABLE_TOOLTIPS = BUILDER.comment("Show stage requirements in item tooltips").define("enableTooltips", true);
        ENABLE_WARNINGS = BUILDER.comment("Show warning overlays when accessing blocked content").define("enableWarnings", true);
        WARNING_DURATION = BUILDER.comment("Duration of warning messages in milliseconds").defineInRange("warningDuration", 5000, 1000, 30000);
        BUILDER.pop();
        BUILDER.push("Behavior");
        TELEPORT_ON_INVALID_DIMENSION = BUILDER.comment("Teleport players to safety if they're in a restricted dimension").define("teleportOnInvalidDimension", true);
        BUILDER.pop();
        BUILDER.push("Performance");
        CACHE_SIZE = BUILDER.comment("Size of the stage checking cache").defineInRange("cacheSize", 1000, 100, 5000);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

