/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.core;

import com.etema.otherstages.cache.StageCache;
import com.etema.otherstages.core.ConfigManager;
import com.etema.otherstages.data.PlayerStageData;
import com.etema.otherstages.data.StageDefinition;
import com.etema.otherstages.network.NetworkHandler;
import com.etema.otherstages.util.EnchantmentFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class StageManager {
    private static final Map<String, StageDefinition> STAGES = new ConcurrentHashMap<String, StageDefinition>();
    private static final Map<UUID, PlayerStageData> PLAYER_DATA = new ConcurrentHashMap<UUID, PlayerStageData>();
    private static final StageCache CACHE = new StageCache();

    public static void registerStage(String stageName, StageDefinition definition) {
        STAGES.put(stageName, definition);
        CACHE.invalidateAll();
    }

    public static StageDefinition getStage(String stageName) {
        return STAGES.get(stageName);
    }

    public static Set<String> getAllStages() {
        return new HashSet<String>(STAGES.keySet());
    }

    public static Collection<StageDefinition> getAllStageDefinitions() {
        return STAGES.values();
    }

    public static PlayerStageData getPlayerData(Player player) {
        return PLAYER_DATA.computeIfAbsent(player.m_20148_(), uuid -> new PlayerStageData((UUID)uuid));
    }

    public static Set<String> getPlayerStages(Player player) {
        return StageManager.getPlayerData(player).getUnlockedStages();
    }

    public static boolean hasStage(Player player, String stageName) {
        return StageManager.getPlayerData(player).hasStage(stageName);
    }

    public static void grantStage(Player player, String stageName) {
        PlayerStageData data = StageManager.getPlayerData(player);
        if (data.addStage(stageName)) {
            CACHE.invalidatePlayer(player.m_20148_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.syncPlayerStages(serverPlayer);
            }
        }
    }

    public static void removeStage(Player player, String stageName) {
        PlayerStageData data = StageManager.getPlayerData(player);
        if (data.removeStage(stageName)) {
            CACHE.invalidatePlayer(player.m_20148_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHandler.syncPlayerStages(serverPlayer);
            }
        }
    }

    public static boolean isItemBlocked(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        String cacheKey = CACHE.getItemKey(player.m_20148_(), stack);
        Boolean cached = CACHE.getItemResult(cacheKey);
        if (cached != null) {
            return cached;
        }
        boolean blocked = StageManager.checkItemBlocked(player, stack);
        CACHE.cacheItemResult(cacheKey, blocked);
        return blocked;
    }

    private static boolean checkItemBlocked(Player player, ItemStack stack) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isItemBlocked(stack) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean playerHasStageOrHigher(Player player, String requiredStage) {
        StageDefinition required = STAGES.get(requiredStage);
        if (required == null) {
            return true;
        }
        Set<String> playerStages = StageManager.getPlayerStages(player);
        if (playerStages.contains(requiredStage)) {
            return true;
        }
        int requiredOrder = required.getOrder();
        for (String playerStage : playerStages) {
            StageDefinition playerStageDefinition = STAGES.get(playerStage);
            if (playerStageDefinition == null || playerStageDefinition.getOrder() < requiredOrder) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnchantmentAllowed(Player player, Enchantment enchantment) {
        if (enchantment == null) {
            return true;
        }
        ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment);
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isEnchantmentBlocked(enchantmentId) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getRequiredStage(Player player, ItemStack stack) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isItemBlocked(stack) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return stage.getDisplayName() + " (required for this item)";
        }
        return null;
    }

    public static boolean canUseItem(Player player, ItemStack stack) {
        return !StageManager.isItemBlocked(player, stack);
    }

    public static boolean canMineWith(Player player, ItemStack tool) {
        return StageManager.canUseItem(player, tool);
    }

    public static boolean canAttackWith(Player player, ItemStack weapon) {
        return StageManager.canUseItem(player, weapon);
    }

    public static boolean canWearArmor(Player player, ItemStack armor) {
        return StageManager.canUseItem(player, armor);
    }

    public static ItemStack filterBlockedEnchantments(Player player, ItemStack stack) {
        if (!stack.m_41720_().toString().equals("minecraft:enchanted_book")) {
            return stack;
        }
        return EnchantmentFilter.filterEnchantedBook(player, stack);
    }

    public static boolean canMobSpawn(Player nearestPlayer, ResourceLocation mobType) {
        if (nearestPlayer == null) {
            return true;
        }
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isMobBlocked(mobType) || StageManager.playerHasStageOrHigher(nearestPlayer, stage.getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean canAccessStructure(Player player, ResourceLocation structureType) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isStructureBlocked(structureType) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return false;
        }
        return true;
    }

    public static boolean canAccessDimension(Player player, ResourceLocation dimension) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isDimensionBlocked(dimension) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getRequiredStageForDimension(Player player, ResourceLocation dimension) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isDimensionBlocked(dimension) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return stage.getTranslatableDisplayName().getString();
        }
        return null;
    }

    public static boolean isRecipeBlocked(Player player, ResourceLocation recipeId) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isRecipeBlocked(recipeId) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return true;
        }
        return false;
    }

    public static void clearCache() {
        CACHE.invalidateAll();
    }

    public static void clearPlayerCache(UUID playerId) {
        CACHE.invalidatePlayer(playerId);
    }

    public static void reloadStages() {
        STAGES.clear();
        CACHE.invalidateAll();
        ConfigManager.loadAllStages();
    }

    public static String getRequiredStageForStructure(Player player, ResourceLocation structureType) {
        for (StageDefinition stage : STAGES.values()) {
            if (!stage.isStructureBlocked(structureType) || StageManager.playerHasStageOrHigher(player, stage.getName())) continue;
            return stage.getTranslatableDisplayName().getString();
        }
        return null;
    }
}

