/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.data;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class BlockedEnchantment {
    private String enchantmentId;
    private int level;
    private boolean exactLevel;

    public BlockedEnchantment(String enchantmentId, int level) {
        this.enchantmentId = enchantmentId;
        this.level = level;
        this.exactLevel = true;
    }

    public BlockedEnchantment(String enchantmentId, int level, boolean exactLevel) {
        this.enchantmentId = enchantmentId;
        this.level = level;
        this.exactLevel = exactLevel;
    }

    public boolean matches(ItemStack enchantedBook) {
        CompoundTag nbt = enchantedBook.m_41783_();
        if (nbt == null) {
            return false;
        }
        ListTag storedEnchants = nbt.m_128437_("StoredEnchantments", 10);
        for (Tag enchantTag : storedEnchants) {
            CompoundTag enchant = (CompoundTag)enchantTag;
            String id = enchant.m_128461_("id");
            int lvl = enchant.m_128451_("lvl");
            if (!id.equals(this.enchantmentId) || !(this.exactLevel ? lvl == this.level : lvl >= this.level)) continue;
            return true;
        }
        return false;
    }

    public String getEnchantmentId() {
        return this.enchantmentId;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isExactLevel() {
        return this.exactLevel;
    }
}

