/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.data;

import com.etema.otherstages.util.NBTMatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BlockedItem {
    private ResourceLocation itemId;
    private CompoundTag nbtPattern;
    private boolean exactMatch;

    public BlockedItem(ResourceLocation itemId) {
        this.itemId = itemId;
        this.exactMatch = false;
    }

    public BlockedItem(ResourceLocation itemId, CompoundTag nbtPattern) {
        this.itemId = itemId;
        this.nbtPattern = nbtPattern;
        this.exactMatch = false;
    }

    public BlockedItem(ResourceLocation itemId, CompoundTag nbtPattern, boolean exactMatch) {
        this.itemId = itemId;
        this.nbtPattern = nbtPattern;
        this.exactMatch = exactMatch;
    }

    public boolean matches(ResourceLocation itemId, ItemStack stack) {
        if (!this.itemId.equals((Object)itemId)) {
            return false;
        }
        if (this.nbtPattern == null || this.nbtPattern.m_128456_()) {
            return true;
        }
        CompoundTag stackNBT = stack.m_41783_();
        if (stackNBT == null) {
            return false;
        }
        return NBTMatcher.matches(stackNBT, this.nbtPattern, this.exactMatch);
    }

    public ResourceLocation getItemId() {
        return this.itemId;
    }

    public CompoundTag getNbtPattern() {
        return this.nbtPattern;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }
}

