/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.data;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class PlayerStageData {
    private UUID playerId;
    private Set<String> unlockedStages;
    private String currentStage;
    private Map<String, Long> stageUnlockTimes;
    private long lastSync;

    public PlayerStageData(UUID playerId) {
        this.playerId = playerId;
        this.unlockedStages = new HashSet<String>();
        this.stageUnlockTimes = new HashMap<String, Long>();
        this.lastSync = System.currentTimeMillis();
    }

    public boolean addStage(String stageName) {
        if (this.unlockedStages.add(stageName)) {
            this.stageUnlockTimes.put(stageName, System.currentTimeMillis());
            this.updateCurrentStage();
            return true;
        }
        return false;
    }

    public boolean removeStage(String stageName) {
        if (this.unlockedStages.remove(stageName)) {
            this.stageUnlockTimes.remove(stageName);
            this.updateCurrentStage();
            return true;
        }
        return false;
    }

    public boolean hasStage(String stageName) {
        return this.unlockedStages.contains(stageName);
    }

    private void updateCurrentStage() {
        this.currentStage = this.unlockedStages.stream().max(Comparator.comparing(this::getStageOrder)).orElse("stone_age");
    }

    private int getStageOrder(String stageName) {
        return stageName.hashCode();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("PlayerId", this.playerId);
        nbt.m_128359_("CurrentStage", this.currentStage != null ? this.currentStage : "");
        nbt.m_128356_("LastSync", this.lastSync);
        ListTag stagesTag = new ListTag();
        for (String stage : this.unlockedStages) {
            stagesTag.add((Object)StringTag.m_129297_((String)stage));
        }
        nbt.m_128365_("UnlockedStages", (Tag)stagesTag);
        CompoundTag timesTag = new CompoundTag();
        for (Map.Entry<String, Long> entry : this.stageUnlockTimes.entrySet()) {
            timesTag.m_128356_(entry.getKey(), entry.getValue().longValue());
        }
        nbt.m_128365_("UnlockTimes", (Tag)timesTag);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.playerId = nbt.m_128342_("PlayerId");
        this.currentStage = nbt.m_128461_("CurrentStage");
        this.lastSync = nbt.m_128454_("LastSync");
        this.unlockedStages.clear();
        ListTag stagesTag = nbt.m_128437_("UnlockedStages", 8);
        for (Tag stageTag : stagesTag) {
            this.unlockedStages.add(stageTag.m_7916_());
        }
        this.stageUnlockTimes.clear();
        CompoundTag timesTag = nbt.m_128469_("UnlockTimes");
        for (String key : timesTag.m_128431_()) {
            this.stageUnlockTimes.put(key, timesTag.m_128454_(key));
        }
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public Set<String> getUnlockedStages() {
        return new HashSet<String>(this.unlockedStages);
    }

    public String getCurrentStage() {
        return this.currentStage;
    }

    public Map<String, Long> getStageUnlockTimes() {
        return new HashMap<String, Long>(this.stageUnlockTimes);
    }

    public long getLastSync() {
        return this.lastSync;
    }

    public void markSynced() {
        this.lastSync = System.currentTimeMillis();
    }
}

