/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.data;

import com.etema.otherstages.data.BlockedEnchantment;
import com.etema.otherstages.data.BlockedItem;
import com.etema.otherstages.progression.ProgressionCondition;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class StageDefinition {
    private String name;
    private String displayName;
    private String description;
    private String color;
    private ResourceLocation icon;
    private int order;
    private Set<BlockedItem> blockedItems = new HashSet<BlockedItem>();
    private Set<ResourceLocation> blockedTags = new HashSet<ResourceLocation>();
    private Set<BlockedEnchantment> blockedEnchantments = new HashSet<BlockedEnchantment>();
    private Set<ResourceLocation> blockedMobs = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> blockedStructures = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> blockedDimensions = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> blockedLoot = new HashSet<ResourceLocation>();
    private Set<ResourceLocation> blockedRecipes = new HashSet<ResourceLocation>();
    private ProgressionCondition unlockCondition;
    private String nextStage;

    public StageDefinition(String name) {
        this.name = name;
        this.displayName = name;
        this.color = "#FFFFFF";
        this.order = 0;
    }

    public boolean isItemBlocked(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        for (BlockedItem blocked : this.blockedItems) {
            if (!blocked.matches(itemId, stack)) continue;
            return true;
        }
        for (ResourceLocation tag : this.blockedTags) {
            if (!this.isItemInTag(stack, tag)) continue;
            return true;
        }
        return false;
    }

    private boolean isItemInTag(ItemStack stack, ResourceLocation tagLocation) {
        try {
            IForgeRegistry registry = ForgeRegistries.ITEMS;
            ITagManager tags = registry.tags();
            ITag tag = tags.getTag(TagKey.m_203882_((ResourceKey)registry.getRegistryKey(), (ResourceLocation)tagLocation));
            return tag.contains((Object)stack.m_41720_());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEnchantmentBlocked(ResourceLocation enchantmentId) {
        return this.blockedEnchantments.stream().anyMatch(blocked -> blocked.getEnchantmentId().equals(enchantmentId.toString()));
    }

    public boolean isMobBlocked(ResourceLocation mobType) {
        return this.blockedMobs.contains(mobType);
    }

    public boolean isStructureBlocked(ResourceLocation structureType) {
        return this.blockedStructures.contains(structureType);
    }

    public boolean isDimensionBlocked(ResourceLocation dimension) {
        return this.blockedDimensions.contains(dimension);
    }

    public boolean isRecipeBlocked(ResourceLocation recipeId) {
        return this.blockedRecipes.contains(recipeId);
    }

    public Component getTranslatableDisplayName() {
        if (this.displayName != null && !this.displayName.startsWith("otherstages.")) {
            return Component.m_237113_((String)this.displayName);
        }
        if (this.displayName != null && this.displayName.startsWith("otherstages.")) {
            return Component.m_237115_((String)this.displayName);
        }
        return Component.m_237113_((String)this.name);
    }

    public Component getTranslatableDescription() {
        if (this.description != null && !this.description.isEmpty() && this.description.startsWith("otherstages.")) {
            return Component.m_237115_((String)this.description);
        }
        if (this.description != null && !this.description.isEmpty()) {
            return Component.m_237113_((String)this.description);
        }
        return Component.m_237119_();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    public int getOrder() {
        return this.order;
    }

    public Set<ResourceLocation> getBlockedDimensions() {
        return new HashSet<ResourceLocation>(this.blockedDimensions);
    }

    public Set<ResourceLocation> getBlockedStructures() {
        return new HashSet<ResourceLocation>(this.blockedStructures);
    }

    public Set<ResourceLocation> getBlockedMobs() {
        return new HashSet<ResourceLocation>(this.blockedMobs);
    }

    public Set<BlockedItem> getBlockedItems() {
        return new HashSet<BlockedItem>(this.blockedItems);
    }

    public Set<ResourceLocation> getBlockedTags() {
        return new HashSet<ResourceLocation>(this.blockedTags);
    }

    public Set<BlockedEnchantment> getBlockedEnchantments() {
        return new HashSet<BlockedEnchantment>(this.blockedEnchantments);
    }

    public Set<ResourceLocation> getBlockedLoot() {
        return new HashSet<ResourceLocation>(this.blockedLoot);
    }

    public Set<ResourceLocation> getBlockedRecipes() {
        return new HashSet<ResourceLocation>(this.blockedRecipes);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setIcon(ResourceLocation icon) {
        this.icon = icon;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void addBlockedLoot(ResourceLocation loot) {
        this.blockedLoot.add(loot);
    }

    public void addBlockedItem(BlockedItem item) {
        this.blockedItems.add(item);
    }

    public void addBlockedTag(ResourceLocation tag) {
        this.blockedTags.add(tag);
    }

    public void addBlockedEnchantment(BlockedEnchantment enchant) {
        this.blockedEnchantments.add(enchant);
    }

    public void addBlockedMob(ResourceLocation mob) {
        this.blockedMobs.add(mob);
    }

    public void addBlockedStructure(ResourceLocation structure) {
        this.blockedStructures.add(structure);
    }

    public void addBlockedDimension(ResourceLocation dimension) {
        this.blockedDimensions.add(dimension);
    }

    public void addBlockedRecipe(ResourceLocation recipe) {
        this.blockedRecipes.add(recipe);
    }

    public ProgressionCondition getUnlockCondition() {
        return this.unlockCondition;
    }

    public void setUnlockCondition(ProgressionCondition condition) {
        this.unlockCondition = condition;
    }

    public String getNextStage() {
        return this.nextStage;
    }

    public void setNextStage(String nextStage) {
        this.nextStage = nextStage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StageDefinition that = (StageDefinition)obj;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "StageDefinition{name='" + this.name + "', displayName='" + this.displayName + "', order=" + this.order + "}";
    }
}

