/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.events;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.ConfigManager;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.network.NetworkHandler;
import com.etema.otherstages.network.packets.DimensionWarningPacket;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherstages", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DimensionAccessHandler {
    private static final Map<UUID, Long> lastWarningTime = new ConcurrentHashMap<UUID, Long>();
    private static final Map<UUID, ResourceLocation> lastBlockedDimension = new ConcurrentHashMap<UUID, ResourceLocation>();
    private static final long WARNING_COOLDOWN = 3000L;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerChangeDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!((Boolean)ConfigManager.ENABLE_STAGE_MODE.get()).booleanValue()) {
            return;
        }
        ResourceKey targetDimension = event.getDimension();
        ResourceLocation dimensionId = targetDimension.m_135782_();
        if (!StageManager.canAccessDimension((Player)player, dimensionId)) {
            event.setCanceled(true);
            String requiredStage = StageManager.getRequiredStageForDimension((Player)player, dimensionId);
            DimensionAccessHandler.sendResponsiveDimensionWarning(player, dimensionId, requiredStage, false);
            if (((Boolean)ConfigManager.ENABLE_WARNINGS.get()).booleanValue()) {
                player.m_6330_(SoundEvents.f_12507_, SoundSource.MASTER, 1.0f, 1.0f);
            }
            OtherStagesMod.LOGGER.info("Blocked player {} from entering dimension {} - requires stage: {}", (Object)player.m_5446_().getString(), (Object)dimensionId, (Object)requiredStage);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!((Boolean)ConfigManager.ENABLE_STAGE_MODE.get()).booleanValue()) {
            return;
        }
        ResourceLocation currentDimension = player2.m_9236_().m_46472_().m_135782_();
        if (!StageManager.canAccessDimension((Player)player2, currentDimension)) {
            if (((Boolean)ConfigManager.TELEPORT_ON_INVALID_DIMENSION.get()).booleanValue()) {
                DimensionAccessHandler.teleportToSafeDimension(player2);
            }
            String requiredStage = StageManager.getRequiredStageForDimension((Player)player2, currentDimension);
            DimensionAccessHandler.sendResponsiveDimensionWarning(player2, currentDimension, requiredStage, true);
        }
    }

    private static void sendResponsiveDimensionWarning(ServerPlayer player, ResourceLocation dimensionId, String requiredStage, boolean isTeleported) {
        if (!((Boolean)ConfigManager.ENABLE_WARNINGS.get()).booleanValue()) {
            return;
        }
        UUID playerId = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastWarning = lastWarningTime.get(playerId);
        ResourceLocation lastBlocked = lastBlockedDimension.get(playerId);
        if (lastWarning != null && currentTime - lastWarning < 3000L && dimensionId.equals((Object)lastBlocked)) {
            return;
        }
        lastWarningTime.put(playerId, currentTime);
        lastBlockedDimension.put(playerId, dimensionId);
        String dimensionName = DimensionAccessHandler.formatDimensionName(dimensionId);
        int durationMs = (Integer)ConfigManager.WARNING_DURATION.get();
        DimensionWarningPacket packet = new DimensionWarningPacket(dimensionName, requiredStage != null ? requiredStage : "", isTeleported, durationMs);
        NetworkHandler.sendToPlayer(packet, player);
    }

    private static void teleportToSafeDimension(ServerPlayer player) {
        try {
            ServerLevel overworld = player.f_8924_.m_129880_(Level.f_46428_);
            if (overworld != null) {
                BlockPos spawnPos = overworld.m_220360_();
                if (player.m_8961_() != null && player.m_8963_().equals((Object)Level.f_46428_)) {
                    spawnPos = player.m_8961_();
                }
                player.m_8999_(overworld, (double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                OtherStagesMod.LOGGER.info("Teleported player {} to safety from restricted dimension", (Object)player.m_5446_().getString());
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Failed to teleport player {} to safety: {}", (Object)player.m_5446_().getString(), (Object)e.getMessage());
        }
    }

    private static String formatDimensionName(ResourceLocation dimensionId) {
        String path = dimensionId.m_135815_();
        String translationKey = "otherstages.dimension." + path;
        MutableComponent translated = Component.m_237115_((String)translationKey);
        if (translated.getString().equals(translationKey)) {
            return Arrays.stream(path.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
        }
        return translated.getString();
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerId = event.getEntity().m_20148_();
        lastWarningTime.remove(playerId);
        lastBlockedDimension.remove(playerId);
    }
}

