/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.events;

import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.integration.RecipeViewerManager;
import com.etema.otherstages.network.NetworkHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StageEventHandler {
    private static final Map<UUID, Long> lastMessageTime = new ConcurrentHashMap<UUID, Long>();
    private static final long MESSAGE_COOLDOWN = 3000L;
    private static final Set<UUID> playersToCheck = new HashSet<UUID>();

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            StageManager.getPlayerData((Player)serverPlayer);
            NetworkHandler.syncPlayerStages(serverPlayer);
            if (serverPlayer.m_9236_().f_46443_) {
                this.scheduleRecipeViewerRefresh(serverPlayer);
            }
            this.scheduleArmorCheck(serverPlayer, 20);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.syncPlayerStages(serverPlayer);
            if (serverPlayer.m_9236_().f_46443_) {
                this.scheduleRecipeViewerRefresh(serverPlayer);
            }
            this.scheduleArmorCheck(serverPlayer, 10);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.syncPlayerStages(serverPlayer);
            if (serverPlayer.m_9236_().f_46443_) {
                this.scheduleRecipeViewerRefresh(serverPlayer);
            }
        }
    }

    private void scheduleRecipeViewerRefresh(ServerPlayer player) {
        new Thread(() -> {
            try {
                Thread.sleep(2000L);
                RecipeViewerManager.refreshForPlayer((Player)player);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private void scheduleArmorCheck(ServerPlayer player, int tickDelay) {
        int[] countdown = new int[]{tickDelay};
        new Thread(() -> {
            try {
                Thread.sleep(tickDelay * 50);
                if (player.m_6084_() && !player.m_213877_()) {
                    playersToCheck.add(player.m_20148_());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    public static void onStagesUpdated(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHandler.syncPlayerStages(serverPlayer);
            if (player.m_9236_().f_46443_) {
                RecipeViewerManager.onPlayerStagesChanged(player);
            }
            playersToCheck.add(player.m_20148_());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack tool;
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (!StageManager.canMineWith(player, tool = player.m_21205_())) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, tool, "mine_with");
            return;
        }
        ItemStack blockAsItem = new ItemStack((ItemLike)event.getLevel().m_8055_(event.getPos()).m_60734_().m_5456_());
        if (StageManager.isItemBlocked(player, blockAsItem)) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, blockAsItem, "mine");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerRightClick(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        ItemStack item = event.getItemStack();
        if (this.isEquippableArmor(item) && StageManager.isItemBlocked(player, item)) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, item, "wear");
            return;
        }
        if (StageManager.isItemBlocked(player, item)) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, item, "use");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        ItemStack item = event.getItemStack();
        if (!item.m_41619_() && StageManager.isItemBlocked(player, item)) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, item, "use");
            return;
        }
        ItemStack blockAsItem = new ItemStack((ItemLike)event.getLevel().m_8055_(event.getPos()).m_60734_().m_5456_());
        if (StageManager.isItemBlocked(player, blockAsItem)) {
            event.setUseBlock(Event.Result.DENY);
            this.sendBlockedMessage(player, blockAsItem, "use");
        }
    }

    private boolean isEquippableArmor(ItemStack stack) {
        return stack.m_41720_() instanceof ArmorItem || stack.m_41720_() instanceof ElytraItem;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerAttack(AttackEntityEvent event) {
        ItemStack weapon;
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (!StageManager.canAttackWith(player, weapon = player.m_21205_())) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, weapon, "attack_with");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInventoryChange(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            playersToCheck.add(serverPlayer.m_20148_());
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Player player;
        if (event.getEntity().m_20193_().m_5776_()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity) instanceof FakePlayer) {
            return;
        }
        for (ItemStack armorItem : player.m_150109_().f_35975_) {
            if (armorItem.m_41619_() || !StageManager.isItemBlocked(player, armorItem)) continue;
            this.dropItemStack(player, armorItem);
            this.sendBlockedMessage(player, armorItem, "wear");
        }
    }

    private void dropItemStack(Player player, ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        ItemStack copy = stack.m_41777_();
        stack.m_41764_(0);
        if (!player.m_150109_().m_36054_(copy)) {
            player.m_36176_(copy, false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_150109_().m_6596_();
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!playersToCheck.isEmpty()) {
            HashSet<UUID> toRemove = new HashSet<UUID>();
            block0: for (UUID playerId : playersToCheck) {
                for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                    if (!player.m_20148_().equals(playerId)) continue;
                    this.checkAndRemoveBlockedArmor((Player)player);
                    toRemove.add(playerId);
                    continue block0;
                }
            }
            playersToCheck.removeAll(toRemove);
        }
    }

    private void checkAndRemoveBlockedArmor(Player player) {
        if (player == null || !player.m_6084_() || player.m_213877_()) {
            return;
        }
        boolean armorChanged = false;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack armorItem = player.m_6844_(slot);
            if (armorItem.m_41619_() || !StageManager.isItemBlocked(player, armorItem)) continue;
            ItemStack removedArmor = armorItem.m_41777_();
            player.m_8061_(slot, ItemStack.f_41583_);
            if (!player.m_150109_().m_36054_(removedArmor)) {
                player.m_36176_(removedArmor, false);
            }
            this.sendBlockedMessage(player, removedArmor, "wear");
            armorChanged = true;
        }
        if (armorChanged && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_36096_.m_38946_();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack tool;
        if (event.getPlayer() instanceof FakePlayer) {
            return;
        }
        Player player = event.getPlayer();
        if (!StageManager.canMineWith(player, tool = player.m_21205_())) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, tool, "mine_with");
            return;
        }
        ItemStack blockAsItem = new ItemStack((ItemLike)event.getState().m_60734_().m_5456_());
        if (StageManager.isItemBlocked(player, blockAsItem)) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, blockAsItem, "mine");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        ItemStack heldItem;
        Player player;
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player && StageManager.isItemBlocked(player = (Player)entity, heldItem = player.m_21205_())) {
            event.setCanceled(true);
            this.sendBlockedMessage(player, heldItem, "place");
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!(player instanceof FakePlayer)) {
                StageManager.getPlayerData(player);
                NetworkHandler.syncPlayerStages(serverPlayer);
                this.scheduleArmorCheck(serverPlayer, 40);
            }
        }
    }

    private void sendBlockedMessage(Player player, ItemStack item, String action) {
        if (!this.shouldSendMessage(player)) {
            return;
        }
        String requiredStage = StageManager.getRequiredStage(player, item);
        if (requiredStage != null) {
            MutableComponent message = Component.m_237110_((String)"otherstages.item_blocked.warning", (Object[])new Object[]{Component.m_237115_((String)("otherstages.item_blocked.action." + action))}).m_130940_(ChatFormatting.RED).m_7220_((Component)item.m_41611_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237110_((String)"otherstages.item_blocked.requires_stage", (Object[])new Object[]{requiredStage}).m_130940_(ChatFormatting.YELLOW));
            player.m_213846_((Component)message);
        }
    }

    private boolean shouldSendMessage(Player player) {
        UUID playerId = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastTime = lastMessageTime.get(playerId);
        if (lastTime == null || currentTime - lastTime > 3000L) {
            lastMessageTime.put(playerId, currentTime);
            return true;
        }
        return false;
    }
}

