/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.events;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.network.NetworkHandler;
import com.etema.otherstages.network.packets.StructureWarningPacket;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherstages", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StructureAccessHandler {
    private static final Map<UUID, ResourceLocation> playersInBlockedStructures = new ConcurrentHashMap<UUID, ResourceLocation>();
    private static final Map<UUID, Long> lastWarningTime = new ConcurrentHashMap<UUID, Long>();
    private static final long WARNING_COOLDOWN = 2000L;
    private static final ResourceLocation[] MONITORED_STRUCTURES = new ResourceLocation[]{new ResourceLocation("minecraft:stronghold"), new ResourceLocation("minecraft:village_plains"), new ResourceLocation("minecraft:nether_fortress"), new ResourceLocation("minecraft:end_city"), new ResourceLocation("minecraft:mansion"), new ResourceLocation("minecraft:monument"), new ResourceLocation("minecraft:bastion_remnant"), new ResourceLocation("minecraft:ancient_city"), new ResourceLocation("minecraft:pillager_outpost"), new ResourceLocation("minecraft:desert_pyramid"), new ResourceLocation("minecraft:jungle_pyramid"), new ResourceLocation("minecraft:shipwreck"), new ResourceLocation("minecraft:ocean_ruin_cold"), new ResourceLocation("minecraft:ruined_portal"), new ResourceLocation("minecraft:buried_treasure"), new ResourceLocation("minecraft:igloo"), new ResourceLocation("minecraft:swamp_hut")};

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        UUID playerUUID = player.m_20148_();
        if (player.f_19797_ % 20 != 0) {
            return;
        }
        try {
            StructureManager structureManager = Objects.requireNonNull(event.player.m_20194_()).m_129880_(player.m_9236_().m_46472_()).m_215010_();
            ResourceLocation currentBlockedStructure = null;
            for (ResourceLocation structureId : MONITORED_STRUCTURES) {
                boolean isInStructure;
                Structure structure = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_7745_(structureId);
                if (structure == null || !(isInStructure = structureManager.m_220494_(player.m_20097_(), structure).m_73603_()) || StageManager.canAccessStructure((Player)player, structureId)) continue;
                currentBlockedStructure = structureId;
                break;
            }
            ResourceLocation previousBlockedStructure = playersInBlockedStructures.get(playerUUID);
            if (currentBlockedStructure != null) {
                if (!currentBlockedStructure.equals((Object)previousBlockedStructure)) {
                    StructureAccessHandler.onPlayerEnterBlockedStructure(player, currentBlockedStructure);
                    playersInBlockedStructures.put(playerUUID, currentBlockedStructure);
                }
            } else if (previousBlockedStructure != null) {
                StructureAccessHandler.onPlayerExitBlockedStructure(player, previousBlockedStructure);
                playersInBlockedStructures.remove(playerUUID);
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error in structure access check for player {}: {}", (Object)player.m_5446_().getString(), (Object)e.getMessage());
        }
    }

    private static void onPlayerEnterBlockedStructure(ServerPlayer player, ResourceLocation structureId) {
        String structureName = StructureAccessHandler.formatStructureName(structureId.m_135815_());
        String requiredStage = StageManager.getRequiredStageForStructure((Player)player, structureId);
        MutableComponent message = requiredStage != null && !requiredStage.isEmpty() ? Component.m_237110_((String)"otherstages.structure_blocked.entered_with_stage", (Object[])new Object[]{structureName, requiredStage}) : Component.m_237110_((String)"otherstages.structure_blocked.entered", (Object[])new Object[]{structureName});
        player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        player.m_213846_((Component)message.m_6881_().m_130940_(ChatFormatting.RED));
        StructureWarningPacket overlayPacket = new StructureWarningPacket(structureName, requiredStage != null ? requiredStage : "", 0, true);
        NetworkHandler.sendToPlayer(overlayPacket, player);
        player.m_6330_(SoundEvents.f_12346_, SoundSource.MASTER, 0.7f, 1.0f);
        OtherStagesMod.LOGGER.info("Player {} entered blocked structure: {}", (Object)player.m_5446_().getString(), (Object)structureId);
    }

    private static void onPlayerExitBlockedStructure(ServerPlayer player, ResourceLocation structureId) {
        String structureName = StructureAccessHandler.formatStructureName(structureId.m_135815_());
        MutableComponent message = Component.m_237110_((String)"otherstages.structure_blocked.exited", (Object[])new Object[]{structureName});
        player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        StructureWarningPacket hideOverlayPacket = new StructureWarningPacket();
        NetworkHandler.sendToPlayer(hideOverlayPacket, player);
        OtherStagesMod.LOGGER.info("Player {} exited blocked structure: {}", (Object)player.m_5446_().getString(), (Object)structureId);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        ResourceLocation blockedStructure = playersInBlockedStructures.get(playerUUID);
        if (blockedStructure != null) {
            event.setCanceled(true);
            StructureAccessHandler.sendInteractionWarning(player2, blockedStructure, "interact");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onPlayerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        ResourceLocation blockedStructure = playersInBlockedStructures.get(playerUUID);
        if (blockedStructure != null) {
            event.setCanceled(true);
            StructureAccessHandler.sendInteractionWarning(player2, blockedStructure, "attack");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID playerUUID = player2.m_20148_();
        ResourceLocation blockedStructure = playersInBlockedStructures.get(playerUUID);
        if (blockedStructure != null) {
            event.setCanceled(true);
            StructureAccessHandler.sendInteractionWarning(player2, blockedStructure, "break");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerUUID = player.m_20148_();
        ResourceLocation blockedStructure = playersInBlockedStructures.get(playerUUID);
        if (blockedStructure != null) {
            event.setCanceled(true);
            StructureAccessHandler.sendInteractionWarning(player, blockedStructure, "place");
        }
    }

    private static void sendInteractionWarning(ServerPlayer player, ResourceLocation structureId, String action) {
        UUID playerUUID = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastWarning = lastWarningTime.get(playerUUID);
        if (lastWarning != null && currentTime - lastWarning < 2000L) {
            return;
        }
        lastWarningTime.put(playerUUID, currentTime);
        String structureName = StructureAccessHandler.formatStructureName(structureId.m_135815_());
        String requiredStage = StageManager.getRequiredStageForStructure((Player)player, structureId);
        MutableComponent message = requiredStage != null && !requiredStage.isEmpty() ? Component.m_237110_((String)"otherstages.structure_blocked.action_denied_with_stage", (Object[])new Object[]{action, structureName, requiredStage}) : Component.m_237110_((String)"otherstages.structure_blocked.action_denied", (Object[])new Object[]{action, structureName});
        player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)message.m_6881_().m_130940_(ChatFormatting.RED)));
    }

    private static String formatStructureName(String name) {
        if (name == null || name.isEmpty()) {
            return "Unknown Structure";
        }
        return Arrays.stream(name.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public static boolean isPlayerInBlockedStructure(ServerPlayer player) {
        return playersInBlockedStructures.containsKey(player.m_20148_());
    }

    public static ResourceLocation getPlayerBlockedStructure(ServerPlayer player) {
        return playersInBlockedStructures.get(player.m_20148_());
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerUUID = event.getEntity().m_20148_();
        playersInBlockedStructures.remove(playerUUID);
        lastWarningTime.remove(playerUUID);
        OtherStagesMod.LOGGER.debug("Cleared structure data for disconnected player: {}", (Object)playerUUID);
    }
}

