/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.integration;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.integration.jei.JEIIntegration;
import com.etema.otherstages.integration.rei.REIIntegration;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;

public class RecipeViewerManager {
    private static boolean JEI_LOADED = false;
    private static boolean REI_LOADED = false;
    private static JEIIntegration jeiIntegration;
    private static REIIntegration reiIntegration;
    private static final Set<String> hiddenRecipes;
    private static final Set<String> hiddenItems;

    public static void init() {
        JEI_LOADED = ModList.get().isLoaded("jei");
        REI_LOADED = ModList.get().isLoaded("roughlyenoughitems");
        OtherStagesMod.LOGGER.info("Recipe viewer integration status:");
        OtherStagesMod.LOGGER.info("JEI: " + (JEI_LOADED ? "loaded" : "not found"));
        OtherStagesMod.LOGGER.info("REI: " + (REI_LOADED ? "loaded" : "not found"));
        if (REI_LOADED) {
            try {
                reiIntegration = new REIIntegration();
                OtherStagesMod.LOGGER.info("REI integration initialized");
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.error("Failed to initialize REI integration", (Throwable)e);
            }
        }
    }

    public static void setJeiIntegration(JEIIntegration integration) {
        jeiIntegration = integration;
        OtherStagesMod.LOGGER.info("JEI integration registered");
    }

    public static void hideItem(String itemId) {
        if (hiddenItems.add(itemId)) {
            RecipeViewerManager.refreshAllViewers();
        }
    }

    public static void showItem(String itemId) {
        if (hiddenItems.remove(itemId)) {
            RecipeViewerManager.refreshAllViewers();
        }
    }

    public static void hideRecipe(String recipeId) {
        if (hiddenRecipes.add(recipeId)) {
            RecipeViewerManager.refreshAllViewers();
        }
    }

    public static void showRecipe(String recipeId) {
        if (hiddenRecipes.remove(recipeId)) {
            RecipeViewerManager.refreshAllViewers();
        }
    }

    public static void refreshAllViewers() {
        try {
            if (JEI_LOADED && jeiIntegration != null) {
                jeiIntegration.refresh(hiddenItems, hiddenRecipes);
            }
            if (REI_LOADED && reiIntegration != null) {
                reiIntegration.refresh(hiddenItems, hiddenRecipes);
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error refreshing recipe viewers", (Throwable)e);
        }
    }

    public static void refreshForPlayer(Player player) {
        if (player == null) {
            return;
        }
        try {
            HashSet<String> playerHiddenItems = new HashSet<String>();
            HashSet<String> playerHiddenRecipes = new HashSet<String>();
            if (JEI_LOADED && jeiIntegration != null) {
                jeiIntegration.refreshForPlayer(player, playerHiddenItems, playerHiddenRecipes);
            }
            if (REI_LOADED && reiIntegration != null) {
                reiIntegration.refreshForPlayer(player, playerHiddenItems, playerHiddenRecipes);
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error refreshing recipe viewers for player", (Throwable)e);
        }
    }

    public static void onPlayerStagesChanged(Player player) {
        if (player != null && player.m_9236_().f_46443_) {
            RecipeViewerManager.refreshForPlayer(player);
        }
    }

    public static boolean isJEILoaded() {
        return JEI_LOADED;
    }

    public static boolean isREILoaded() {
        return REI_LOADED;
    }

    static {
        hiddenRecipes = new HashSet<String>();
        hiddenItems = new HashSet<String>();
    }
}

