/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.integration.jei;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.integration.RecipeViewerManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    private final List<ItemStack> hiddenItems = new ArrayList<ItemStack>();
    private IJeiRuntime jeiRuntime;

    public JEIIntegration() {
        if (EffectiveSide.get().isClient()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, false, RecipesUpdatedEvent.class, e -> this.updateItems());
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("otherstages", "jei_integration");
    }

    public void onRuntimeAvailable(@NotNull IJeiRuntime jeiRuntime) {
        this.jeiRuntime = jeiRuntime;
        OtherStagesMod.LOGGER.info("JEI runtime available");
        RecipeViewerManager.setJeiIntegration(this);
        this.updateItems();
    }

    public void refresh(Set<String> hiddenItems, Set<String> hiddenRecipes) {
        if (this.jeiRuntime == null) {
            return;
        }
        this.updateItemsWithSet(hiddenItems, hiddenRecipes);
    }

    public void refreshForPlayer(Player player, Set<String> hiddenItems, Set<String> hiddenRecipes) {
        if (this.jeiRuntime == null || player == null) {
            return;
        }
        this.updateItemsForPlayer(player);
    }

    private void updateItems() {
        LocalPlayer player;
        if (this.jeiRuntime != null && (player = Minecraft.m_91087_().f_91074_) != null) {
            this.updateItemsForPlayer((Player)player);
        }
    }

    private void updateItemsWithSet(Set<String> hiddenItemIds, Set<String> hiddenRecipes) {
        if (this.jeiRuntime == null) {
            return;
        }
        try {
            IIngredientManager ingredientManager = this.jeiRuntime.getIngredientManager();
            this.restoreItems(ingredientManager);
            this.collectItemsByIds(ingredientManager, hiddenItemIds);
            this.hideItems(ingredientManager);
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error updating JEI with item set", (Throwable)e);
        }
    }

    private void updateItemsForPlayer(Player player) {
        if (this.jeiRuntime == null || player == null) {
            return;
        }
        try {
            IIngredientManager ingredientManager = this.jeiRuntime.getIngredientManager();
            this.restoreItems(ingredientManager);
            this.collectItemsForPlayer(ingredientManager, player);
            this.hideItems(ingredientManager);
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error updating JEI for player", (Throwable)e);
        }
    }

    private void restoreItems(IIngredientManager ingredientManager) {
        if (!this.hiddenItems.isEmpty()) {
            try {
                OtherStagesMod.LOGGER.debug("JEI restoring {} items", (Object)this.hiddenItems.size());
                ingredientManager.addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.hiddenItems);
                this.hiddenItems.clear();
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.warn("Error restoring JEI items", (Throwable)e);
                this.hiddenItems.clear();
            }
        }
    }

    private void collectItemsByIds(IIngredientManager ingredientManager, Set<String> hiddenItemIds) {
        for (String itemId : hiddenItemIds) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation(itemId);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item == null) continue;
                ItemStack stack = new ItemStack((ItemLike)item);
                for (ItemStack jeiStack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
                    if (jeiStack.m_41720_() != item) continue;
                    this.hiddenItems.add(jeiStack.m_41777_());
                }
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.warn("Invalid item ID for JEI: " + itemId, (Throwable)e);
            }
        }
    }

    private void collectItemsForPlayer(IIngredientManager ingredientManager, Player player) {
        try {
            for (ItemStack itemStack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
                if (itemStack.m_41619_() || !StageManager.isItemBlocked(player, itemStack)) continue;
                this.hiddenItems.add(itemStack.m_41777_());
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error collecting items for player", (Throwable)e);
        }
    }

    private void hideItems(IIngredientManager ingredientManager) {
        if (!this.hiddenItems.isEmpty()) {
            try {
                OtherStagesMod.LOGGER.debug("JEI hiding {} items", (Object)this.hiddenItems.size());
                ingredientManager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, this.hiddenItems);
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.error("Error hiding JEI items", (Throwable)e);
            }
        }
    }

    public IJeiRuntime getJeiRuntime() {
        return this.jeiRuntime;
    }
}

