/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.integration.rei;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@REIPluginClient
public class REIIntegration
implements REIClientPlugin {
    private static REIIntegration instance;
    private final List<EntryStack<?>> currentlyHiddenEntries = new ArrayList();

    public REIIntegration() {
        instance = this;
        OtherStagesMod.LOGGER.info("REI Integration initialized using BasicFilteringRule");
    }

    public static REIIntegration getInstance() {
        return instance;
    }

    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        this.updateItems(rule);
    }

    public void refresh(Set<String> hiddenItems, Set<String> hiddenRecipes) {
        try {
            BasicFilteringRule rule = FilteringRuleTypeRegistry.getInstance().basic();
            this.updateItemsWithSet(rule, hiddenItems);
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error refreshing REI", (Throwable)e);
        }
    }

    public void refreshForPlayer(Player player, Set<String> hiddenItems, Set<String> hiddenRecipes) {
        if (player == null) {
            return;
        }
        try {
            BasicFilteringRule rule = FilteringRuleTypeRegistry.getInstance().basic();
            this.updateItemsForPlayer(rule, player);
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error refreshing REI for player", (Throwable)e);
        }
    }

    private void updateItems(BasicFilteringRule<?> rule) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            this.updateItemsForPlayer(rule, (Player)player);
        }
    }

    private void updateItemsWithSet(BasicFilteringRule<?> rule, Set<String> hiddenItems) {
        this.restoreHiddenEntries(rule);
        ArrayList entriesToHide = new ArrayList();
        for (String itemId : hiddenItems) {
            try {
                ResourceLocation resourceLocation = new ResourceLocation(itemId);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item == null) continue;
                ItemStack stack = new ItemStack((ItemLike)item);
                EntryRegistry.getInstance().getEntryStacks().forEach(entryStack -> {
                    Holder.Reference entryItem;
                    if (ForgeRegistries.ITEMS.getDelegate(entryStack.getIdentifier()).isPresent() && (entryItem = (Holder.Reference)ForgeRegistries.ITEMS.getDelegate(entryStack.getIdentifier()).get()).get() == item) {
                        entriesToHide.add((EntryStack<?>)entryStack);
                    }
                });
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.warn("Invalid item ID for REI: " + itemId, (Throwable)e);
            }
        }
        this.hideEntries(rule, entriesToHide);
    }

    private void updateItemsForPlayer(BasicFilteringRule<?> rule, Player player) {
        this.restoreHiddenEntries(rule);
        ArrayList entriesToHide = new ArrayList();
        EntryRegistry.getInstance().getEntryStacks().forEach(entryStack -> {
            try {
                ItemStack stack;
                if (ForgeRegistries.ITEMS.getDelegate(entryStack.getIdentifier()).isPresent() && !(stack = new ItemStack((Holder)ForgeRegistries.ITEMS.getDelegate(entryStack.getIdentifier()).get())).m_41619_() && StageManager.isItemBlocked(player, stack)) {
                    entriesToHide.add((EntryStack<?>)entryStack);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.hideEntries(rule, entriesToHide);
    }

    private void restoreHiddenEntries(BasicFilteringRule<?> rule) {
        if (!this.currentlyHiddenEntries.isEmpty()) {
            try {
                OtherStagesMod.LOGGER.debug("REI restoring {} items", (Object)this.currentlyHiddenEntries.size());
                for (EntryStack<?> entry : this.currentlyHiddenEntries) {
                    rule.show(entry);
                }
                this.currentlyHiddenEntries.clear();
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.warn("Error restoring REI entries", (Throwable)e);
                this.currentlyHiddenEntries.clear();
            }
        }
    }

    private void hideEntries(BasicFilteringRule<?> rule, List<EntryStack<?>> entriesToHide) {
        if (!entriesToHide.isEmpty()) {
            try {
                OtherStagesMod.LOGGER.debug("REI hiding {} items", (Object)entriesToHide.size());
                for (EntryStack<?> entry : entriesToHide) {
                    rule.hide(entry);
                }
                this.currentlyHiddenEntries.addAll(entriesToHide);
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.error("Error hiding REI entries", (Throwable)e);
            }
        }
    }

    private void refreshREI() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            try {
                BasicFilteringRule rule = FilteringRuleTypeRegistry.getInstance().basic();
                this.updateItemsForPlayer(rule, (Player)player);
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.error("Error refreshing REI", (Throwable)e);
            }
        }
    }
}

