/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.items;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.util.StageAnalyzer;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StageAnalyzerItem
extends Item {
    public StageAnalyzerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (!player.m_6144_()) {
            if (!level.f_46443_) {
                player.m_213846_((Component)Component.m_237115_((String)"item.otherstages.stage_analyzer.use_instructions").m_130940_(ChatFormatting.YELLOW));
            }
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (this.isValidContainer(blockEntity)) {
                String containerType = this.detectContainerType(blockEntity);
                this.analyzeGenericContainer(player, blockEntity, pos, containerType);
                return InteractionResult.SUCCESS;
            }
            this.analyzeBlock(player, level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isValidContainer(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return false;
        }
        String className = blockEntity.getClass().getSimpleName().toLowerCase();
        String fullClassName = blockEntity.getClass().getName().toLowerCase();
        if (blockEntity instanceof BaseContainerBlockEntity) {
            return true;
        }
        if (blockEntity instanceof Container) {
            return true;
        }
        if (className.contains("ironchest") || fullClassName.contains("ironchests") || className.contains("copperchest") || className.contains("goldchest") || className.contains("diamondchest") || className.contains("crystalchest") || className.contains("obsidianchest") || className.contains("dirtchest")) {
            return true;
        }
        if (fullClassName.contains("sophisticatedstorage") || className.contains("sophisticatedbarrel") || className.contains("sophisticatedchest") || className.contains("sophisticatedshulker")) {
            return true;
        }
        if (fullClassName.contains("appliedenergistics") || className.contains("meinterface") || className.contains("terminal") || className.contains("chest") && fullClassName.contains("ae2")) {
            return true;
        }
        if (fullClassName.contains("refinedstorage") || className.contains("controller") || className.contains("grid") || className.contains("interface") && fullClassName.contains("rs")) {
            return true;
        }
        if (fullClassName.contains("enderstorage") || className.contains("enderchest") || className.contains("endertank")) {
            return true;
        }
        if (fullClassName.contains("storagedrawers") || className.contains("drawer") || className.contains("compacting")) {
            return true;
        }
        if (fullClassName.contains("actuallyadditions") || className.contains("giantchest") || className.contains("crate")) {
            return true;
        }
        if (fullClassName.contains("thermal") || className.contains("strongbox") || className.contains("cache")) {
            return true;
        }
        if (fullClassName.contains("mekanism") || className.contains("bin") || className.contains("tank") && className.contains("item")) {
            return true;
        }
        if (fullClassName.contains("expandedstorage") || className.contains("barrel") || className.contains("chest") && fullClassName.contains("expandedstorage")) {
            return true;
        }
        if (fullClassName.contains("quark") && (className.contains("chest") || className.contains("crate"))) {
            return true;
        }
        if (fullClassName.contains("colossalchests") || className.contains("colossalchest")) {
            return true;
        }
        if (fullClassName.contains("storagenetwork") || className.contains("storage") && className.contains("request")) {
            return true;
        }
        if (fullClassName.contains("yabba") || className.contains("itembarrel") || className.contains("antibarrel")) {
            return true;
        }
        return this.hasContainerMethods(blockEntity);
    }

    private String detectContainerType(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return "unknown";
        }
        String className = blockEntity.getClass().getSimpleName().toLowerCase();
        String fullClassName = blockEntity.getClass().getName().toLowerCase();
        if (fullClassName.contains("ironchests")) {
            return "ironchests";
        }
        if (fullClassName.contains("sophisticatedstorage")) {
            return "sophisticated";
        }
        if (fullClassName.contains("appliedenergistics")) {
            return "ae2";
        }
        if (fullClassName.contains("refinedstorage")) {
            return "refined_storage";
        }
        if (fullClassName.contains("enderstorage")) {
            return "ender_storage";
        }
        if (fullClassName.contains("storagedrawers")) {
            return "drawers";
        }
        if (fullClassName.contains("actuallyadditions")) {
            return "actually_additions";
        }
        if (fullClassName.contains("thermal")) {
            return "thermal";
        }
        if (fullClassName.contains("mekanism")) {
            return "mekanism";
        }
        if (fullClassName.contains("expandedstorage")) {
            return "expanded_storage";
        }
        if (fullClassName.contains("quark")) {
            return "quark";
        }
        if (fullClassName.contains("colossalchests")) {
            return "colossal";
        }
        if (fullClassName.contains("storagenetwork")) {
            return "storage_network";
        }
        if (fullClassName.contains("yabba")) {
            return "yabba";
        }
        if (blockEntity instanceof BaseContainerBlockEntity) {
            return "vanilla";
        }
        return "modded";
    }

    private boolean hasContainerMethods(BlockEntity blockEntity) {
        try {
            Class<?> clazz = blockEntity.getClass();
            String[] containerMethods = new String[]{"getContainerSize", "size", "getSlots", "getStackInSlot", "getItem", "setItem", "getItems", "getContents", "insertItem", "extractItem", "canPlaceItem", "canTakeItem"};
            int methodCount = 0;
            for (String methodName : containerMethods) {
                if (!this.hasMethod(clazz, methodName) || ++methodCount < 2) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasMethod(Class<?> clazz, String methodName) {
        try {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void analyzeGenericContainer(Player player, BlockEntity blockEntity, BlockPos pos, String containerType) {
        try {
            String analysis;
            if (blockEntity instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
                analysis = StageAnalyzer.analyzeContainer(container);
            } else {
                analysis = StageAnalyzer.analyzeGenericContainer(blockEntity);
            }
            player.m_213846_((Component)Component.m_237113_((String)"\u2713 Configuration Generated Successfully").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
            player.m_213846_((Component)Component.m_237113_((String)("Container Type: " + containerType.toUpperCase())).m_130940_(ChatFormatting.AQUA));
            player.m_213846_((Component)Component.m_237113_((String)("Location: " + pos.m_123344_())).m_130940_(ChatFormatting.GRAY));
            player.m_213846_((Component)Component.m_237113_((String)"File saved to: config/otherstages/generated/").m_130940_(ChatFormatting.YELLOW));
            player.m_213846_((Component)Component.m_237113_((String)"Check your config folder for the generated JSON file!").m_130940_(ChatFormatting.GREEN));
            this.showModInfo(player, containerType);
            String[] lines = analysis.split("\n");
            if (lines.length > 0) {
                player.m_213846_((Component)Component.m_237113_((String)"Preview:").m_130940_(ChatFormatting.GRAY));
                for (int i = 0; i < Math.min(3, lines.length); ++i) {
                    if (lines[i].trim().isEmpty()) continue;
                    player.m_213846_((Component)Component.m_237113_((String)("  " + lines[i])).m_130940_(ChatFormatting.WHITE));
                }
                if (lines.length > 3) {
                    player.m_213846_((Component)Component.m_237113_((String)"  ... (see full file in config)").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237113_((String)("Analysis failed: " + e.getMessage())).m_130940_(ChatFormatting.RED));
            player.m_213846_((Component)Component.m_237113_((String)("Container class: " + blockEntity.getClass().getSimpleName())).m_130940_(ChatFormatting.GRAY));
            OtherStagesMod.LOGGER.error("Error analyzing container at " + String.valueOf(pos), (Throwable)e);
        }
    }

    private void showModInfo(Player player, String containerType) {
        switch (containerType) {
            case "ironchests": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Iron Chests mod detected - All chest types supported!").m_130940_(ChatFormatting.BLUE));
                break;
            }
            case "sophisticated": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Sophisticated Storage detected - Advanced features included!").m_130940_(ChatFormatting.LIGHT_PURPLE));
                break;
            }
            case "ae2": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Applied Energistics 2 detected - ME system compatible!").m_130940_(ChatFormatting.DARK_AQUA));
                break;
            }
            case "refined_storage": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Refined Storage detected - RS system compatible!").m_130940_(ChatFormatting.DARK_BLUE));
                break;
            }
            case "drawers": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Storage Drawers detected - Drawer system supported!").m_130940_(ChatFormatting.GOLD));
                break;
            }
            case "thermal": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Thermal Series detected - Industrial storage supported!").m_130940_(ChatFormatting.RED));
                break;
            }
            case "mekanism": {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Mekanism detected - Advanced storage compatible!").m_130940_(ChatFormatting.DARK_GREEN));
                break;
            }
            default: {
                player.m_213846_((Component)Component.m_237113_((String)"\u2713 Modded container detected - Using advanced reflection!").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    private void analyzeBlock(Player player, Level level, BlockPos pos) {
        try {
            String analysis = StageAnalyzer.analyzeBlock(level, pos);
            player.m_213846_((Component)Component.m_237115_((String)"otherstages.analyzer.block_header").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            player.m_213846_((Component)Component.m_237110_((String)"otherstages.analyzer.block_at", (Object[])new Object[]{pos.m_123344_()}).m_130940_(ChatFormatting.AQUA));
            player.m_213846_((Component)Component.m_237113_((String)analysis).m_130940_(ChatFormatting.WHITE));
            player.m_213846_((Component)Component.m_237115_((String)"item.otherstages.stage_analyzer.not_container").m_130940_(ChatFormatting.YELLOW));
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237110_((String)"otherstages.analyzer.error", (Object[])new Object[]{"block", e.getMessage()}).m_130940_(ChatFormatting.RED));
            OtherStagesMod.LOGGER.error("Error analyzing block at " + String.valueOf(pos), (Throwable)e);
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.otherstages.stage_analyzer.tooltip.title").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"Compatible with 15+ storage mods:").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 Iron Chests, Sophisticated Storage").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 Applied Energistics 2, Refined Storage").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 Storage Drawers, Thermal, Mekanism").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)"\u2022 And many more via reflection!").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"\u27d0 Shift + Right Click to analyze").m_130940_(ChatFormatting.YELLOW));
    }
}

