/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.mixin;

import com.etema.otherstages.core.StageManager;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin {
    @Unique
    private Player otherstages_player;

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;)V"}, at={@At(value="TAIL")})
    private void capturePlayer(int containerId, Inventory playerInventory, CallbackInfo ci) {
        this.otherstages_player = playerInventory.f_35978_;
    }

    @Inject(method={"mayPickup"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventPickupBlocked(Player player, boolean hasStack, CallbackInfoReturnable<Boolean> cir) {
        if (this.otherstages_isOperationBlocked()) {
            cir.setReturnValue((Object)false);
            Player player2 = this.otherstages_player;
            if (player2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player2;
                MutableComponent message = Component.m_237115_((String)"operation_blocked").m_130940_(ChatFormatting.RED);
                serverPlayer.m_213846_((Component)message);
            }
        }
    }

    @Inject(method={"createResult"}, at={@At(value="TAIL")})
    private void clearBlockedResult(CallbackInfo ci) {
        AnvilMenu anvilMenu = (AnvilMenu)this;
        if (!anvilMenu.m_38853_(2).m_7993_().m_41619_() && this.otherstages_isOperationBlocked()) {
            anvilMenu.m_38853_(2).m_5852_(ItemStack.f_41583_);
        }
    }

    @Unique
    private boolean otherstages_isOperationBlocked() {
        AnvilMenu anvilMenu = (AnvilMenu)this;
        ItemStack leftItem = anvilMenu.m_38853_(0).m_7993_();
        ItemStack rightItem = anvilMenu.m_38853_(1).m_7993_();
        if (leftItem.m_41619_() && rightItem.m_41619_()) {
            return false;
        }
        if (!leftItem.m_41619_() && StageManager.isItemBlocked(this.otherstages_player, leftItem)) {
            return true;
        }
        if (!rightItem.m_41619_() && StageManager.isItemBlocked(this.otherstages_player, rightItem)) {
            return true;
        }
        if (rightItem.m_41720_() instanceof EnchantedBookItem) {
            Map enchantmentsInBook = EnchantmentHelper.m_44831_((ItemStack)rightItem);
            for (Enchantment enchantment : enchantmentsInBook.keySet()) {
                if (StageManager.isEnchantmentAllowed(this.otherstages_player, enchantment)) continue;
                return true;
            }
        }
        return false;
    }
}

