/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.mixin;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import java.lang.reflect.Field;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CraftingMenu.class})
public class CraftingMenuMixin {
    @Shadow
    public CraftingContainer f_39348_;
    @Shadow
    public ResultContainer f_39349_;

    @Inject(method={"slotsChanged"}, at={@At(value="HEAD")})
    private void preventBlockedCrafting(Container container, CallbackInfo ci) {
        CraftingMenu menu = (CraftingMenu)this;
        try {
            Player player = this.getPlayerFromMenu(menu);
            if (player == null) {
                return;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                GameType gameType = serverPlayer.f_8941_.m_9290_();
                if (gameType == GameType.CREATIVE) {
                    return;
                }
            }
            for (int i = 0; i < this.f_39348_.m_6643_(); ++i) {
                ItemStack item = this.f_39348_.m_8020_(i);
                if (item.m_41619_() || !StageManager.isItemBlocked(player, item)) continue;
                this.f_39349_.m_6836_(0, ItemStack.f_41583_);
                return;
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.warn("CraftingMenuMixin (HEAD) failed: " + e.getMessage());
        }
    }

    @Inject(method={"slotsChanged"}, at={@At(value="RETURN")})
    private void checkCraftingResult(Container container, CallbackInfo ci) {
        CraftingMenu menu = (CraftingMenu)this;
        try {
            ItemStack result;
            Player player = this.getPlayerFromMenu(menu);
            if (player == null) {
                return;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                GameType gameType = serverPlayer.f_8941_.m_9290_();
                if (gameType == GameType.CREATIVE) {
                    return;
                }
            }
            if (!(result = this.f_39349_.m_8020_(0)).m_41619_() && StageManager.isItemBlocked(player, result)) {
                this.f_39349_.m_6836_(0, ItemStack.f_41583_);
                OtherStagesMod.LOGGER.debug("Blocked crafting result: {}", (Object)result.m_41611_().getString());
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.warn("CraftingMenuMixin (RETURN) failed: " + e.getMessage());
        }
    }

    private Player getPlayerFromMenu(CraftingMenu menu) {
        block6: {
            Container container = menu.m_38853_((int)0).f_40218_;
            if (!(container instanceof Inventory)) break block6;
            Inventory playerInventory = (Inventory)container;
            return playerInventory.f_35978_;
        }
        try {
            Field field = CraftingMenu.class.getDeclaredField("player");
            field.setAccessible(true);
            return (Player)field.get(menu);
        }
        catch (Exception field) {
            try {
                for (int i = 0; i < menu.f_38839_.size(); ++i) {
                    Slot slot = menu.m_38853_(i);
                    Container container = slot.f_40218_;
                    if (!(container instanceof Inventory)) continue;
                    Inventory playerInventory = (Inventory)container;
                    return playerInventory.f_35978_;
                }
            }
            catch (Exception e) {
                OtherStagesMod.LOGGER.warn("Failed to get player from crafting menu: " + e.getMessage());
            }
        }
        return null;
    }
}

