/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.mixin;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import java.lang.reflect.Field;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InventoryMenu.class})
public class InventoryMenuMixin {
    @Shadow
    private CraftingContainer f_39701_;
    @Shadow
    private ResultContainer f_39702_;
    private static Field ownerField = null;

    @Inject(method={"slotsChanged"}, at={@At(value="RETURN")})
    private void checkInventoryCrafting(Container container, CallbackInfo ci) {
        try {
            Player player = this.getPlayerViaReflection();
            if (player == null) {
                return;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                GameType gameType = serverPlayer.f_8941_.m_9290_();
                if (gameType == GameType.CREATIVE) {
                    return;
                }
            }
            for (int i = 0; i < this.f_39701_.m_6643_(); ++i) {
                ItemStack item = this.f_39701_.m_8020_(i);
                if (item.m_41619_() || !StageManager.isItemBlocked(player, item)) continue;
                this.f_39702_.m_6836_(0, ItemStack.f_41583_);
                return;
            }
            ItemStack result = this.f_39702_.m_8020_(0);
            if (!result.m_41619_() && StageManager.isItemBlocked(player, result)) {
                this.f_39702_.m_6836_(0, ItemStack.f_41583_);
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.warn("InventoryMenuMixin failed: " + e.getMessage());
        }
    }

    private Player getPlayerViaReflection() {
        try {
            if (ownerField == null) {
                ownerField = InventoryMenu.class.getDeclaredField("owner");
                ownerField.setAccessible(true);
            }
            return (Player)ownerField.get(this);
        }
        catch (Exception e) {
            return this.getPlayerAlternative();
        }
    }

    private Player getPlayerAlternative() {
        try {
            InventoryMenu menu = (InventoryMenu)this;
            for (int i = 0; i < menu.f_38839_.size(); ++i) {
                Slot slot = menu.m_38853_(i);
                Container container = slot.f_40218_;
                if (!(container instanceof Inventory)) continue;
                Inventory playerInventory = (Inventory)container;
                return playerInventory.f_35978_;
            }
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.debug("Alternative player search failed: " + e.getMessage());
        }
        return null;
    }
}

