/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.mixin;

import com.etema.otherstages.core.StageManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerMixin {
    @Inject(method={"hasCorrectToolForDrops"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkStageForMining(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        ItemStack tool = player.m_21205_();
        if (!StageManager.canMineWith(player, tool)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getDestroySpeed"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventMiningWithBlockedTools(BlockState state, CallbackInfoReturnable<Float> cir) {
        Player player = (Player)this;
        ItemStack tool = player.m_21205_();
        if (!StageManager.canMineWith(player, tool)) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }
}

