/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.network;

import com.etema.otherstages.network.packets.DimensionWarningPacket;
import com.etema.otherstages.network.packets.StructureWarningPacket;
import com.etema.otherstages.network.packets.SyncPlayerStagesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("otherstages", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;

    public static void init() {
        INSTANCE.messageBuilder(SyncPlayerStagesPacket.class, NetworkHandler.nextId()).encoder(SyncPlayerStagesPacket::encode).decoder(SyncPlayerStagesPacket::decode).consumerMainThread(SyncPlayerStagesPacket::handle).add();
        INSTANCE.messageBuilder(StructureWarningPacket.class, NetworkHandler.nextId()).encoder(StructureWarningPacket::encode).decoder(StructureWarningPacket::decode).consumerMainThread(StructureWarningPacket::handle).add();
        INSTANCE.messageBuilder(DimensionWarningPacket.class, NetworkHandler.nextId()).encoder(DimensionWarningPacket::encode).decoder(DimensionWarningPacket::decode).consumerMainThread(DimensionWarningPacket::handle).add();
    }

    private static int nextId() {
        return id++;
    }

    public static void syncPlayerStages(ServerPlayer player) {
        SyncPlayerStagesPacket packet = new SyncPlayerStagesPacket(player);
        INSTANCE.sendTo((Object)packet, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToPlayer(StructureWarningPacket packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }

    public static void sendToPlayer(DimensionWarningPacket packet, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)packet);
    }
}

