/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.network.packets;

import com.etema.otherstages.client.gui.DimensionWarningOverlay;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class DimensionWarningPacket {
    private final String dimensionName;
    private final String requiredStage;
    private final boolean isTeleported;
    private final boolean showWarning;
    private final int duration;

    public DimensionWarningPacket(String dimensionName, String requiredStage, boolean isTeleported, int duration) {
        this.dimensionName = dimensionName;
        this.requiredStage = requiredStage;
        this.isTeleported = isTeleported;
        this.duration = duration;
        this.showWarning = true;
    }

    public DimensionWarningPacket() {
        this.dimensionName = "";
        this.requiredStage = "";
        this.isTeleported = false;
        this.duration = 0;
        this.showWarning = false;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.showWarning);
        if (this.showWarning) {
            buf.m_130070_(this.dimensionName != null ? this.dimensionName : "");
            buf.m_130070_(this.requiredStage != null ? this.requiredStage : "");
            buf.writeBoolean(this.isTeleported);
            buf.writeInt(this.duration);
        }
    }

    public static DimensionWarningPacket decode(FriendlyByteBuf buf) {
        boolean showWarning = buf.readBoolean();
        if (showWarning) {
            String dimensionName = buf.m_130277_();
            String requiredStage = buf.m_130277_();
            boolean isTeleported = buf.readBoolean();
            int duration = buf.readInt();
            return new DimensionWarningPacket(dimensionName, requiredStage, isTeleported, duration);
        }
        return new DimensionWarningPacket();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (this.showWarning) {
                DimensionWarningOverlay.showWarning(this.dimensionName, this.requiredStage, this.duration, this.isTeleported);
            } else {
                DimensionWarningOverlay.hideWarning();
            }
        });
        context.setPacketHandled(true);
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public String getRequiredStage() {
        return this.requiredStage;
    }

    public boolean isTeleported() {
        return this.isTeleported;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public int getDuration() {
        return this.duration;
    }
}

