/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.network.packets;

import com.etema.otherstages.client.gui.StructureWarningOverlay;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class StructureWarningPacket {
    private final String structureName;
    private final String requiredStage;
    private final int remainingSeconds;
    private final boolean showWarning;
    private final boolean isAccessDenied;

    public StructureWarningPacket(String structureName, String requiredStage, int remainingSeconds) {
        this.structureName = structureName;
        this.requiredStage = requiredStage;
        this.remainingSeconds = remainingSeconds;
        this.showWarning = true;
        this.isAccessDenied = false;
    }

    public StructureWarningPacket(String structureName, String requiredStage, int remainingSeconds, boolean isAccessDenied) {
        this.structureName = structureName;
        this.requiredStage = requiredStage;
        this.remainingSeconds = remainingSeconds;
        this.showWarning = true;
        this.isAccessDenied = isAccessDenied;
    }

    public StructureWarningPacket() {
        this.structureName = "";
        this.requiredStage = "";
        this.remainingSeconds = 0;
        this.showWarning = false;
        this.isAccessDenied = false;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.showWarning);
        if (this.showWarning) {
            buf.m_130070_(this.structureName != null ? this.structureName : "");
            buf.m_130070_(this.requiredStage != null ? this.requiredStage : "");
            buf.writeInt(this.remainingSeconds);
            buf.writeBoolean(this.isAccessDenied);
        }
    }

    public static StructureWarningPacket decode(FriendlyByteBuf buf) {
        boolean showWarning = buf.readBoolean();
        if (showWarning) {
            String structureName = buf.m_130277_();
            String requiredStage = buf.m_130277_();
            int remainingSeconds = buf.readInt();
            boolean isAccessDenied = buf.readBoolean();
            return new StructureWarningPacket(structureName, requiredStage, remainingSeconds, isAccessDenied);
        }
        return new StructureWarningPacket();
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (this.showWarning) {
                StructureWarningOverlay.showWarning(this.structureName, this.requiredStage, this.remainingSeconds, this.isAccessDenied);
            } else {
                StructureWarningOverlay.hideWarning();
            }
        });
        context.setPacketHandled(true);
    }

    public String getStructureName() {
        return this.structureName;
    }

    public String getRequiredStage() {
        return this.requiredStage;
    }

    public int getRemainingSeconds() {
        return this.remainingSeconds;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public boolean isAccessDenied() {
        return this.isAccessDenied;
    }
}

