/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.network.packets;

import com.etema.otherstages.client.events.ClientRecipeViewerHandler;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.data.PlayerStageData;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncPlayerStagesPacket {
    private final UUID playerId;
    private final Set<String> unlockedStages;
    private final String currentStage;

    public SyncPlayerStagesPacket(ServerPlayer player) {
        PlayerStageData data = StageManager.getPlayerData((Player)player);
        this.playerId = player.m_20148_();
        this.unlockedStages = data.getUnlockedStages();
        this.currentStage = data.getCurrentStage();
    }

    public SyncPlayerStagesPacket(UUID playerId, Set<String> unlockedStages, String currentStage) {
        this.playerId = playerId;
        this.unlockedStages = unlockedStages;
        this.currentStage = currentStage;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.writeInt(this.unlockedStages.size());
        for (String stage : this.unlockedStages) {
            buf.m_130070_(stage);
        }
        buf.m_130070_(this.currentStage != null ? this.currentStage : "");
    }

    public static SyncPlayerStagesPacket decode(FriendlyByteBuf buf) {
        UUID playerId = buf.m_130259_();
        int stageCount = buf.readInt();
        HashSet<String> unlockedStages = new HashSet<String>();
        for (int i = 0; i < stageCount; ++i) {
            unlockedStages.add(buf.m_130277_());
        }
        String currentStage = buf.m_130277_();
        if (currentStage.isEmpty()) {
            currentStage = null;
        }
        return new SyncPlayerStagesPacket(playerId, unlockedStages, currentStage);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20148_().equals(this.playerId)) {
                PlayerStageData clientData = StageManager.getPlayerData((Player)Minecraft.m_91087_().f_91074_);
                clientData.getUnlockedStages().clear();
                clientData.getUnlockedStages().addAll(this.unlockedStages);
                StageManager.clearPlayerCache(this.playerId);
                ClientRecipeViewerHandler.onStagesUpdated();
            }
        });
        context.setPacketHandled(true);
    }
}

