/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.progression;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class ProgressionCondition {
    public abstract boolean check(Player var1);

    public abstract String getDescription();

    public static class CraftCountCondition
    extends ProgressionCondition {
        private final ResourceLocation itemId;
        private final int requiredCrafts;

        public CraftCountCondition(ResourceLocation itemId, int requiredCrafts) {
            this.itemId = itemId;
            this.requiredCrafts = requiredCrafts;
        }

        @Override
        public boolean check(Player player) {
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.itemId);
            if (item == null) {
                return false;
            }
            int crafts = serverPlayer.m_8951_().m_13015_(Stats.f_12981_.m_12902_((Object)item));
            return crafts >= this.requiredCrafts;
        }

        @Override
        public String getDescription() {
            return "Craft " + this.requiredCrafts + "x " + this.itemId.toString();
        }
    }

    public static class KillCountCondition
    extends ProgressionCondition {
        private final ResourceLocation entityType;
        private final int requiredKills;

        public KillCountCondition(ResourceLocation entityType, int requiredKills) {
            this.entityType = entityType;
            this.requiredKills = requiredKills;
        }

        @Override
        public boolean check(Player player) {
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EntityType entityTypeObj = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.entityType);
            if (entityTypeObj == null) {
                return false;
            }
            int kills = serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_((Object)entityTypeObj));
            return kills >= this.requiredKills;
        }

        @Override
        public String getDescription() {
            return "Kill " + this.requiredKills + "x " + this.entityType.toString();
        }
    }

    public static class DimensionCondition
    extends ProgressionCondition {
        private final ResourceLocation dimension;

        public DimensionCondition(ResourceLocation dimension) {
            this.dimension = dimension;
        }

        @Override
        public boolean check(Player player) {
            ResourceLocation currentDim = player.m_9236_().m_46472_().m_135782_();
            return currentDim.equals((Object)this.dimension);
        }

        @Override
        public String getDescription() {
            return "Be in dimension: " + this.dimension.toString();
        }
    }

    public static class ExperienceLevelCondition
    extends ProgressionCondition {
        private final int requiredLevel;
        private final boolean consumeLevels;

        public ExperienceLevelCondition(int requiredLevel, boolean consumeLevels) {
            this.requiredLevel = requiredLevel;
            this.consumeLevels = consumeLevels;
        }

        @Override
        public boolean check(Player player) {
            if (player.f_36078_ >= this.requiredLevel) {
                if (this.consumeLevels) {
                    player.m_6749_(-this.requiredLevel);
                }
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Reach level " + this.requiredLevel + (this.consumeLevels ? " (levels consumed)" : "");
        }
    }

    public static class ItemCountCondition
    extends ProgressionCondition {
        private final ResourceLocation itemId;
        private final int requiredCount;
        private final boolean consumeItems;

        public ItemCountCondition(ResourceLocation itemId, int requiredCount, boolean consumeItems) {
            this.itemId = itemId;
            this.requiredCount = requiredCount;
            this.consumeItems = consumeItems;
        }

        @Override
        public boolean check(Player player) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.itemId);
            if (item == null) {
                return false;
            }
            int totalCount = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (stack.m_41720_() != item) continue;
                totalCount += stack.m_41613_();
            }
            if (totalCount >= this.requiredCount) {
                if (this.consumeItems) {
                    int remaining = this.requiredCount;
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        if (stack.m_41720_() != item || remaining <= 0) continue;
                        int toRemove = Math.min(remaining, stack.m_41613_());
                        stack.m_41774_(toRemove);
                        remaining -= toRemove;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Have " + this.requiredCount + "x " + this.itemId.toString() + (this.consumeItems ? " (consumed)" : "");
        }
    }

    public static class AdvancementCondition
    extends ProgressionCondition {
        private final ResourceLocation advancement;

        public AdvancementCondition(ResourceLocation advancement) {
            this.advancement = advancement;
        }

        @Override
        public boolean check(Player player) {
            if (!(player instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement adv = serverPlayer.f_8924_.m_129889_().m_136041_(this.advancement);
            if (adv == null) {
                return false;
            }
            return serverPlayer.m_8960_().m_135996_(adv).m_8193_();
        }

        @Override
        public String getDescription() {
            return "Complete advancement: " + this.advancement.toString();
        }
    }

    public static class OrCondition
    extends ProgressionCondition {
        private final List<ProgressionCondition> conditions;

        public OrCondition(List<ProgressionCondition> conditions) {
            this.conditions = new ArrayList<ProgressionCondition>(conditions);
        }

        @Override
        public boolean check(Player player) {
            return this.conditions.stream().anyMatch(condition -> condition.check(player));
        }

        @Override
        public String getDescription() {
            return "Any of: " + this.conditions.stream().map(ProgressionCondition::getDescription).reduce((a, b) -> a + " OR " + b).orElse("None");
        }
    }

    public static class AndCondition
    extends ProgressionCondition {
        private final List<ProgressionCondition> conditions;

        public AndCondition(List<ProgressionCondition> conditions) {
            this.conditions = new ArrayList<ProgressionCondition>(conditions);
        }

        @Override
        public boolean check(Player player) {
            return this.conditions.stream().allMatch(condition -> condition.check(player));
        }

        @Override
        public String getDescription() {
            return "All of: " + this.conditions.stream().map(ProgressionCondition::getDescription).reduce((a, b) -> a + ", " + b).orElse("None");
        }
    }
}

