/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.progression;

import com.etema.otherstages.OtherStagesMod;
import com.etema.otherstages.core.StageManager;
import com.etema.otherstages.data.StageDefinition;
import com.etema.otherstages.progression.ProgressionCondition;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="otherstages")
public class StageProgressionSystem {
    private static final Map<UUID, Long> lastProgressionCheck = new ConcurrentHashMap<UUID, Long>();
    private static final long PROGRESSION_CHECK_COOLDOWN = 1000L;

    @SubscribeEvent
    public static void onPlayerAdvancement(AdvancementEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StageProgressionSystem.checkProgression((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StageProgressionSystem.checkProgressionWithCooldown((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onEntityKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            StageProgressionSystem.checkProgressionWithCooldown((Player)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StageProgressionSystem.checkProgression((Player)player2);
        }
    }

    public static void checkProgression(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Collection<StageDefinition> allStages = StageManager.getAllStageDefinitions();
        Set<String> playerStages = StageManager.getPlayerStages(player);
        for (StageDefinition stage : allStages) {
            ProgressionCondition condition;
            if (playerStages.contains(stage.getName()) || (condition = stage.getUnlockCondition()) == null || !condition.check(player)) continue;
            StageManager.grantStage(player, stage.getName());
            MutableComponent message = Component.m_237115_((String)"otherstages.progression.stage_unlocked").m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}).m_7220_((Component)Component.m_237113_((String)stage.getTranslatableDisplayName().getString()).m_130940_(ChatFormatting.GOLD));
            serverPlayer.m_213846_((Component)message);
            String description = stage.getTranslatableDescription().getString();
            if (description != null && !description.isEmpty()) {
                serverPlayer.m_213846_((Component)Component.m_237113_((String)description).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            }
            OtherStagesMod.LOGGER.info("Player {} unlocked stage: {}", (Object)player.m_5446_().getString(), (Object)stage.getTranslatableDisplayName().getString());
            player.m_6330_(SoundEvents.f_12275_, SoundSource.MASTER, 0.5f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StageProgressionSystem.checkProgressionWithCooldown((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StageProgressionSystem.checkProgressionWithCooldown((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            StageProgressionSystem.checkProgression((Player)player2);
        }
    }

    private static void checkProgressionWithCooldown(Player player) {
        UUID playerId = player.m_20148_();
        long currentTime = System.currentTimeMillis();
        Long lastCheck = lastProgressionCheck.get(playerId);
        if (lastCheck == null || currentTime - lastCheck > 1000L) {
            lastProgressionCheck.put(playerId, currentTime);
            StageProgressionSystem.checkProgression(player);
        }
    }

    public static void forceCheckProgression(Player player) {
        StageProgressionSystem.checkProgression(player);
    }
}

