/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class NBTMatcher {
    public static boolean matches(CompoundTag stackNBT, CompoundTag pattern, boolean exactMatch) {
        if (pattern == null || pattern.m_128456_()) {
            return true;
        }
        if (stackNBT == null) {
            return false;
        }
        for (String key : pattern.m_128431_()) {
            if (!stackNBT.m_128441_(key)) {
                return false;
            }
            Tag patternValue = pattern.m_128423_(key);
            Tag stackValue = stackNBT.m_128423_(key);
            if (NBTMatcher.matchesTag(stackValue, patternValue, exactMatch)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesTag(Tag stackTag, Tag patternTag, boolean exactMatch) {
        if (stackTag == null || patternTag == null) {
            return stackTag == patternTag;
        }
        if (stackTag.m_7060_() != patternTag.m_7060_()) {
            return false;
        }
        switch (patternTag.m_7060_()) {
            case 10: {
                return NBTMatcher.matchesCompound((CompoundTag)stackTag, (CompoundTag)patternTag, exactMatch);
            }
            case 9: {
                return NBTMatcher.matchesList((ListTag)stackTag, (ListTag)patternTag, exactMatch);
            }
            case 8: {
                return NBTMatcher.matchesString(stackTag.m_7916_(), patternTag.m_7916_());
            }
            case 3: {
                return NBTMatcher.matchesInt(((IntTag)stackTag).m_7047_(), ((IntTag)patternTag).m_7047_());
            }
        }
        return stackTag.equals(patternTag);
    }

    private static boolean matchesCompound(CompoundTag stackNBT, CompoundTag patternNBT, boolean exactMatch) {
        for (String key : patternNBT.m_128431_()) {
            if (!stackNBT.m_128441_(key)) {
                return false;
            }
            if (NBTMatcher.matchesTag(stackNBT.m_128423_(key), patternNBT.m_128423_(key), exactMatch)) continue;
            return false;
        }
        return !exactMatch || stackNBT.m_128440_() == patternNBT.m_128440_();
    }

    private static boolean matchesList(ListTag stackList, ListTag patternList, boolean exactMatch) {
        if (exactMatch && stackList.size() != patternList.size()) {
            return false;
        }
        if (!patternList.isEmpty() && patternList.get(0) instanceof CompoundTag) {
            return NBTMatcher.matchesEnchantmentList(stackList, patternList);
        }
        for (int i = 0; i < patternList.size(); ++i) {
            if (i >= stackList.size()) {
                return false;
            }
            if (NBTMatcher.matchesTag(stackList.get(i), patternList.get(i), exactMatch)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesEnchantmentList(ListTag stackList, ListTag patternList) {
        for (Tag patternTag : patternList) {
            CompoundTag patternEnchant = (CompoundTag)patternTag;
            String patternId = patternEnchant.m_128461_("id");
            int patternLevel = patternEnchant.m_128451_("lvl");
            boolean found = false;
            for (Tag stackTag : stackList) {
                CompoundTag stackEnchant = (CompoundTag)stackTag;
                String stackId = stackEnchant.m_128461_("id");
                int stackLevel = stackEnchant.m_128451_("lvl");
                if (!patternId.equals(stackId) || patternLevel != stackLevel) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesString(String stackValue, String patternValue) {
        if (patternValue.contains("*")) {
            String regex = patternValue.replace("*", ".*");
            return stackValue.matches(regex);
        }
        return stackValue.equals(patternValue);
    }

    private static boolean matchesInt(int stackValue, int patternValue) {
        return stackValue == patternValue;
    }
}

