/*
 * Decompiled with CFR 0.152.
 */
package com.etema.otherstages.util;

import com.etema.otherstages.OtherStagesMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class StageAnalyzer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static String analyzeContainer(BaseContainerBlockEntity container) {
        ArrayList<String> itemLines = new ArrayList<String>();
        HashSet<String> processedItems = new HashSet<String>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            String itemLine;
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_() || processedItems.contains(itemLine = StageAnalyzer.createItemLine(stack))) continue;
            processedItems.add(itemLine);
            itemLines.add(itemLine);
        }
        StageAnalyzer.saveToConfigFolderFlat(itemLines, StageAnalyzer.generateFileNameFromItems(itemLines));
        return String.join((CharSequence)",\n", itemLines);
    }

    public static String analyzeGenericContainer(BlockEntity blockEntity) {
        List<Object> itemLines = new ArrayList();
        HashSet processedItems = new HashSet();
        try {
            itemLines = StageAnalyzer.isSophisticatedStorage(blockEntity) ? StageAnalyzer.analyzeSophisticatedStorage(blockEntity) : (StageAnalyzer.hasForgeCapability(blockEntity) ? StageAnalyzer.analyzeForgeCapability(blockEntity) : StageAnalyzer.analyzeReflectionContainer(blockEntity));
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Failed to analyze generic container: " + e.getMessage());
            return "// Error analyzing container: " + e.getMessage() + "\n// Container class: " + blockEntity.getClass().getName() + "\n// Try with vanilla containers if this persists";
        }
        StageAnalyzer.saveToConfigFolderFlat(itemLines, StageAnalyzer.generateFileNameFromItems(itemLines));
        return String.join((CharSequence)",\n", itemLines);
    }

    private static boolean isSophisticatedStorage(BlockEntity blockEntity) {
        String className = blockEntity.getClass().getName().toLowerCase();
        return className.contains("sophisticatedstorage") || className.contains("sophisticatedcore");
    }

    private static List<String> analyzeSophisticatedStorage(BlockEntity blockEntity) throws Exception {
        ArrayList<String> itemLines = new ArrayList<String>();
        HashSet<String> processedItems = new HashSet<String>();
        try {
            Object inventory;
            IItemHandler itemHandler;
            LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (capability.isPresent() && (itemHandler = (IItemHandler)capability.orElse(null)) != null) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    String itemLine;
                    ItemStack stack = itemHandler.getStackInSlot(i);
                    if (stack.m_41619_() || processedItems.contains(itemLine = StageAnalyzer.createItemLine(stack))) continue;
                    processedItems.add(itemLine);
                    itemLines.add(itemLine);
                }
                return itemLines;
            }
            Class<?> clazz = blockEntity.getClass();
            Method inventoryMethod = null;
            try {
                inventoryMethod = clazz.getMethod("getInventoryHandler", new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                try {
                    inventoryMethod = clazz.getMethod("getStorageWrapper", new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        inventoryMethod = clazz.getMethod("getWrappedStorageHandler", new Class[0]);
                    }
                    catch (NoSuchMethodException e3) {
                        Field[] fields;
                        for (Field field : fields = clazz.getDeclaredFields()) {
                            if (!field.getName().contains("inventory") && !field.getName().contains("handler") && !field.getName().contains("storage")) continue;
                            field.setAccessible(true);
                            Object inventory2 = field.get(blockEntity);
                            if (!(inventory2 instanceof IItemHandler)) continue;
                            IItemHandler handler = (IItemHandler)inventory2;
                            return StageAnalyzer.analyzeItemHandler(handler);
                        }
                        throw new Exception("No inventory method found for Sophisticated Storage");
                    }
                }
            }
            if (inventoryMethod != null && (inventory = inventoryMethod.invoke((Object)blockEntity, new Object[0])) instanceof IItemHandler) {
                IItemHandler handler = (IItemHandler)inventory;
                return StageAnalyzer.analyzeItemHandler(handler);
            }
            throw new Exception("Could not access Sophisticated Storage inventory");
        }
        catch (Exception e) {
            OtherStagesMod.LOGGER.error("Error with Sophisticated Storage analysis: " + e.getMessage());
            throw e;
        }
    }

    private static List<String> analyzeItemHandler(IItemHandler handler) {
        ArrayList<String> itemLines = new ArrayList<String>();
        HashSet<String> processedItems = new HashSet<String>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            String itemLine;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || processedItems.contains(itemLine = StageAnalyzer.createItemLine(stack))) continue;
            processedItems.add(itemLine);
            itemLines.add(itemLine);
        }
        return itemLines;
    }

    private static boolean hasForgeCapability(BlockEntity blockEntity) {
        try {
            LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
            return capability.isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<String> analyzeForgeCapability(BlockEntity blockEntity) throws Exception {
        IItemHandler itemHandler;
        LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (capability.isPresent() && (itemHandler = (IItemHandler)capability.orElse(null)) != null) {
            return StageAnalyzer.analyzeItemHandler(itemHandler);
        }
        throw new Exception("ForgeCapability not available");
    }

    private static List<String> analyzeReflectionContainer(BlockEntity blockEntity) throws Exception {
        ArrayList<String> itemLines = new ArrayList<String>();
        HashSet<String> processedItems = new HashSet<String>();
        int containerSize = StageAnalyzer.getContainerSize(blockEntity);
        for (int i = 0; i < containerSize; ++i) {
            String itemLine;
            ItemStack stack = StageAnalyzer.getItemFromContainer(blockEntity, i);
            if (stack.m_41619_() || processedItems.contains(itemLine = StageAnalyzer.createItemLine(stack))) continue;
            processedItems.add(itemLine);
            itemLines.add(itemLine);
        }
        return itemLines;
    }

    private static String createItemLine(ItemStack stack) {
        JsonObject nbtObj;
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        JsonObject itemObj = new JsonObject();
        itemObj.addProperty("item", itemId.toString());
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && !nbt.m_128456_() && (nbtObj = StageAnalyzer.simplifyNBTFlat(nbt)).size() > 0) {
            itemObj.add("nbt", (JsonElement)nbtObj);
        }
        return GSON.toJson((JsonElement)itemObj).replace("\n", "").replace("  ", "");
    }

    private static JsonObject simplifyNBTFlat(CompoundTag nbt) {
        JsonObject result = new JsonObject();
        for (String key : nbt.m_128431_()) {
            Tag tag = nbt.m_128423_(key);
            if (tag == null || !StageAnalyzer.isRelevantNBTKey(key)) continue;
            StageAnalyzer.addNbtToJsonFlat(result, key, tag);
        }
        return result;
    }

    private static void addNbtToJsonFlat(JsonObject jsonObject, String key, Tag tag) {
        switch (tag.m_7060_()) {
            case 1: {
                jsonObject.addProperty(key, (Number)((ByteTag)tag).m_7063_());
                break;
            }
            case 2: {
                jsonObject.addProperty(key, (Number)((ShortTag)tag).m_7053_());
                break;
            }
            case 3: {
                jsonObject.addProperty(key, (Number)((IntTag)tag).m_7047_());
                break;
            }
            case 4: {
                jsonObject.addProperty(key, (Number)((LongTag)tag).m_7046_());
                break;
            }
            case 5: {
                jsonObject.addProperty(key, (Number)Float.valueOf(((FloatTag)tag).m_7057_()));
                break;
            }
            case 6: {
                jsonObject.addProperty(key, (Number)((DoubleTag)tag).m_7061_());
                break;
            }
            case 8: {
                jsonObject.addProperty(key, tag.m_7916_());
                break;
            }
            case 9: {
                JsonArray array = new JsonArray();
                ListTag listTag = (ListTag)tag;
                if (key.equals("StoredEnchantments") || key.equals("Enchantments")) {
                    for (int i = 0; i < listTag.size(); ++i) {
                        Tag element = listTag.get(i);
                        if (!(element instanceof CompoundTag)) continue;
                        CompoundTag enchantTag = (CompoundTag)element;
                        JsonObject enchantObj = new JsonObject();
                        enchantObj.addProperty("id", enchantTag.m_128461_("id"));
                        enchantObj.addProperty("lvl", (Number)enchantTag.m_128451_("lvl"));
                        array.add((JsonElement)enchantObj);
                    }
                } else {
                    block16: for (int i = 0; i < listTag.size(); ++i) {
                        Tag element = listTag.get(i);
                        if (element instanceof CompoundTag) {
                            array.add((JsonElement)StageAnalyzer.simplifyNBTFlat((CompoundTag)element));
                            continue;
                        }
                        switch (element.m_7060_()) {
                            case 8: {
                                array.add(element.m_7916_());
                                continue block16;
                            }
                            case 3: {
                                array.add((Number)((IntTag)element).m_7047_());
                            }
                        }
                    }
                }
                jsonObject.add(key, (JsonElement)array);
                break;
            }
            case 10: {
                jsonObject.add(key, (JsonElement)StageAnalyzer.simplifyNBTFlat((CompoundTag)tag));
            }
        }
    }

    private static void saveToConfigFolderFlat(List<String> itemLines, String fileName) {
        try {
            File configDir = FMLPaths.CONFIGDIR.get().toFile();
            File otherStagesDir = new File(configDir, "otherstages");
            File generatedDir = new File(otherStagesDir, "generated");
            if (!generatedDir.exists()) {
                generatedDir.mkdirs();
            }
            LocalDateTime now = LocalDateTime.now();
            String timestamp = now.format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
            String fullFileName = fileName + "_" + timestamp + ".json";
            File outputFile = new File(generatedDir, fullFileName);
            try (FileWriter writer = new FileWriter(outputFile);){
                writer.write("// Generated stage configuration\n");
                writer.write("// Copy these lines to your stage configuration file\n");
                writer.write("// Format: one item per line, comma-separated\n\n");
                for (int i = 0; i < itemLines.size(); ++i) {
                    writer.write(itemLines.get(i));
                    if (i < itemLines.size() - 1) {
                        writer.write(",\n");
                        continue;
                    }
                    writer.write("\n");
                }
            }
            OtherStagesMod.LOGGER.info("Stage configuration saved to: {}", (Object)outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            OtherStagesMod.LOGGER.error("Failed to save stage configuration file", (Throwable)e);
        }
    }

    private static String generateFileNameFromItems(List<String> itemLines) {
        HashSet<String> itemTypes = new HashSet<String>();
        HashSet<String> materials = new HashSet<String>();
        HashSet<String> enchantments = new HashSet<String>();
        for (String line : itemLines) {
            if (line.contains("netherite")) {
                materials.add("netherite");
            } else if (line.contains("diamond")) {
                materials.add("diamond");
            } else if (line.contains("iron")) {
                materials.add("iron");
            } else if (line.contains("gold")) {
                materials.add("golden");
            }
            if (line.contains("_sword") || line.contains("_axe") || line.contains("_pickaxe") || line.contains("_shovel") || line.contains("_hoe")) {
                itemTypes.add("tools");
            } else if (line.contains("_helmet") || line.contains("_chestplate") || line.contains("_leggings") || line.contains("_boots")) {
                itemTypes.add("armor");
            } else if (line.contains("enchanted_book")) {
                itemTypes.add("enchanted_books");
            }
            if (line.contains("sharpness")) {
                enchantments.add("sharpness");
            }
            if (!line.contains("protection")) continue;
            enchantments.add("protection");
        }
        StringBuilder stageName = new StringBuilder();
        if (!materials.isEmpty()) {
            stageName.append((String)materials.iterator().next()).append("_");
        }
        if (!itemTypes.isEmpty()) {
            stageName.append((String)itemTypes.iterator().next()).append("_");
        }
        if (!enchantments.isEmpty()) {
            stageName.append((String)enchantments.iterator().next()).append("_");
        }
        if (stageName.length() == 0) {
            stageName.append("mixed_items_");
        }
        stageName.append("stage");
        return stageName.toString();
    }

    private static int getContainerSize(BlockEntity blockEntity) throws Exception {
        Class<?> clazz = blockEntity.getClass();
        try {
            Method method = clazz.getMethod("getContainerSize", new Class[0]);
            return (Integer)method.invoke((Object)blockEntity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = clazz.getMethod("size", new Class[0]);
                return (Integer)method.invoke((Object)blockEntity, new Object[0]);
            }
            catch (NoSuchMethodException e2) {
                if (blockEntity instanceof Container) {
                    Container container = (Container)blockEntity;
                    return container.m_6643_();
                }
                throw new Exception("No container size method found");
            }
        }
    }

    private static ItemStack getItemFromContainer(BlockEntity blockEntity, int slot) throws Exception {
        Class<?> clazz = blockEntity.getClass();
        try {
            Method method = clazz.getMethod("getItem", Integer.TYPE);
            return (ItemStack)method.invoke((Object)blockEntity, slot);
        }
        catch (NoSuchMethodException e) {
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                return container.m_8020_(slot);
            }
            throw new Exception("No getItem method found");
        }
    }

    private static boolean isRelevantNBTKey(String key) {
        return switch (key) {
            case "StoredEnchantments" -> true;
            case "Enchantments" -> true;
            case "display" -> true;
            case "SkullOwner" -> true;
            case "BlockEntityTag" -> true;
            case "Items" -> true;
            case "Potion" -> true;
            case "CustomPotionEffects" -> true;
            case "author", "title", "pages" -> true;
            case "Fireworks" -> true;
            case "Explosion" -> true;
            case "map" -> true;
            default -> false;
        };
    }

    public static String analyzeBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        JsonObject result = new JsonObject();
        result.addProperty("block", blockId.toString());
        result.addProperty("position", pos.m_123344_());
        if (!state.m_61147_().isEmpty()) {
            JsonObject properties = new JsonObject();
            state.m_61148_().forEach((property, value) -> properties.addProperty(property.m_61708_(), value.toString()));
            result.add("properties", (JsonElement)properties);
        }
        return GSON.toJson((JsonElement)result);
    }

    public static String analyzeSingleItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return "{}";
        }
        return StageAnalyzer.createItemLine(stack);
    }
}

