/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.input;

import bookeditor.client.editor.interaction.ImageInteraction;
import bookeditor.client.editor.interaction.TextBoxInteraction;
import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.render.TextBoxRenderer;
import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;

@Environment(value=EnvType.CLIENT)
public class EditorMouseHandler {
    private int clickCount = 0;
    private long lastClickTime = 0L;

    public EditorMode handleMouseClick(int mx, int my, boolean editable, BookData.Page page, EditorMode currentMode, ImageInteraction imageInteraction, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, TextBoxRenderer textBoxRenderer, class_327 textRenderer, int contentScreenLeft, int contentScreenTop, double scale, int scrollY, Runnable pushSnapshot) {
        this.updateClickCount();
        if (currentMode == EditorMode.TEXT_MODE && textBoxInteraction.isEditingText()) {
            if (this.handleActiveTextClick(mx, my, page, textBoxInteraction, textBoxCaret, textBoxRenderer, textRenderer, contentScreenLeft, contentScreenTop, scale, scrollY)) {
                return currentMode;
            }
            textBoxInteraction.setEditingText(false);
            textBoxCaret.clearSelection();
            currentMode = EditorMode.OBJECT_MODE;
        }
        imageInteraction.clearSelection();
        textBoxInteraction.clearSelection();
        if (imageInteraction.mouseClicked(mx, my, editable, pushSnapshot, page)) {
            return EditorMode.OBJECT_MODE;
        }
        if (textBoxInteraction.mouseClicked(mx, my, editable, pushSnapshot, page)) {
            if (this.clickCount >= 2 && editable && this.beginTextEditingIfDoubleClick(textBoxInteraction, textBoxCaret, page)) {
                return EditorMode.TEXT_MODE;
            }
            return EditorMode.OBJECT_MODE;
        }
        return currentMode;
    }

    private void updateClickCount() {
        long currentTime = System.currentTimeMillis();
        this.clickCount = currentTime - this.lastClickTime < 500L ? ++this.clickCount : 1;
        this.lastClickTime = currentTime;
    }

    private boolean handleActiveTextClick(int mx, int my, BookData.Page page, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, TextBoxRenderer textBoxRenderer, class_327 textRenderer, int contentScreenLeft, int contentScreenTop, double scale, int scrollY) {
        int selectedIdx = textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx < 0 || selectedIdx >= page.nodes.size()) {
            return false;
        }
        BookData.Node node = page.nodes.get(selectedIdx);
        if (!(node instanceof BookData.TextBoxNode)) {
            return false;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)node;
        int boxScreenX = contentScreenLeft + (int)Math.round(scale * (double)box.x);
        int boxScreenY = contentScreenTop + (int)Math.round(scale * (double)(box.y - scrollY));
        int boxScreenW = (int)Math.round(scale * (double)box.width);
        int boxScreenH = (int)Math.round(scale * (double)box.height);
        if (mx >= boxScreenX && mx <= boxScreenX + boxScreenW && my >= boxScreenY && my <= boxScreenY + boxScreenH) {
            int localX = (int)Math.round((double)(mx - boxScreenX) / scale);
            int localY = (int)Math.round((double)(my - boxScreenY) / scale);
            int charIdx = textBoxRenderer.getCharIndexAtPosition(textRenderer, box, localX, localY);
            textBoxCaret.setCharIndex(charIdx);
            textBoxCaret.clearSelection();
            return true;
        }
        return false;
    }

    private boolean beginTextEditingIfDoubleClick(TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, BookData.Page page) {
        int selectedIdx = textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx < 0 || selectedIdx >= page.nodes.size()) {
            return false;
        }
        BookData.Node node = page.nodes.get(selectedIdx);
        if (!(node instanceof BookData.TextBoxNode)) {
            return false;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)node;
        textBoxInteraction.setEditingText(true);
        textBoxCaret.reset();
        textBoxCaret.ensureWithinBounds(box);
        return true;
    }

    public boolean handleMouseDrag(int mx, int my, EditorMode mode, boolean editable, ImageInteraction imageInteraction, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, TextBoxRenderer textBoxRenderer, class_327 textRenderer, BookData.Page page, int contentScreenLeft, int contentScreenTop, double scale, int scrollY) {
        BookData.Node node;
        int selectedIdx;
        if (!editable) {
            return false;
        }
        if (mode == EditorMode.TEXT_MODE && textBoxInteraction.isEditingText() && (selectedIdx = textBoxInteraction.getSelectedTextBoxIndex()) >= 0 && selectedIdx < page.nodes.size() && (node = page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode) {
            BookData.TextBoxNode box = (BookData.TextBoxNode)node;
            int boxScreenX = contentScreenLeft + (int)Math.round(scale * (double)box.x);
            int boxScreenY = contentScreenTop + (int)Math.round(scale * (double)(box.y - scrollY));
            int localX = (int)Math.round((double)(mx - boxScreenX) / scale);
            int localY = (int)Math.round((double)(my - boxScreenY) / scale);
            int charIdx = textBoxRenderer.getCharIndexAtPosition(textRenderer, box, localX, localY);
            if (!textBoxCaret.hasSelection()) {
                textBoxCaret.setAnchor(textBoxCaret.getCharIndex());
            }
            textBoxCaret.setCharIndex(charIdx);
            return true;
        }
        if (imageInteraction.mouseDragged(mx, my, true, scale, page)) {
            return true;
        }
        if (textBoxInteraction.mouseDragged(mx, my, true, scale, page)) {
            return true;
        }
        return true;
    }
}

