/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.render;

import bookeditor.client.editor.interaction.ImageInteraction;
import bookeditor.client.editor.interaction.TextBoxInteraction;
import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.render.CaretRenderer;
import bookeditor.client.editor.render.ImageRenderer;
import bookeditor.client.editor.render.TextBoxRenderer;
import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.data.BookData;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class EditorRenderer {
    private final TextBoxRenderer textBoxRenderer = new TextBoxRenderer();
    private final ImageRenderer imageRenderer = new ImageRenderer();
    private final CaretRenderer caretRenderer = new CaretRenderer();

    public void render(class_332 ctx, BookData.Page page, EditorMode mode, ImageInteraction imageInteraction, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, class_327 textRenderer, boolean isFocused, boolean editable, int startScreenX, int startScreenY, int canvasScreenTop, double scale, int scrollY, int logicalW, int logicalH) {
        imageInteraction.beginFrame();
        textBoxInteraction.beginFrame();
        this.imageRenderer.render(ctx, page, imageInteraction, startScreenX, startScreenY - (int)Math.round(scale * (double)scrollY), canvasScreenTop, scale, logicalW, logicalH);
        if (page != null) {
            for (int i = 0; i < page.nodes.size(); ++i) {
                BookData.Node node = page.nodes.get(i);
                if (!(node instanceof BookData.TextBoxNode)) continue;
                BookData.TextBoxNode box = (BookData.TextBoxNode)node;
                this.renderTextBox(ctx, box, i, mode, textBoxInteraction, textBoxCaret, textRenderer, isFocused, editable, startScreenX, startScreenY, scale, scrollY);
            }
        }
        imageInteraction.renderSelectionHandles(ctx);
        textBoxInteraction.renderSelectionHandles(ctx);
    }

    private void renderTextBox(class_332 ctx, BookData.TextBoxNode box, int index, EditorMode mode, TextBoxInteraction textBoxInteraction, TextBoxCaret textBoxCaret, class_327 textRenderer, boolean isFocused, boolean editable, int startScreenX, int startScreenY, double scale, int scrollY) {
        int boxScreenX = startScreenX + (int)Math.round(scale * (double)box.x);
        int boxScreenY = startScreenY + (int)Math.round(scale * (double)(box.y - scrollY));
        int boxScreenW = (int)Math.round(scale * (double)box.width);
        int boxScreenH = (int)Math.round(scale * (double)box.height);
        ctx.method_25294(boxScreenX, boxScreenY, boxScreenX + boxScreenW, boxScreenY + boxScreenH, box.bgArgb);
        boolean isSelected = textBoxInteraction.getSelectedTextBoxIndex() == index;
        boolean showCaret = isSelected && mode == EditorMode.TEXT_MODE && textBoxInteraction.isEditingText();
        boolean showSelection = isSelected && mode == EditorMode.TEXT_MODE;
        TextBoxRenderer.CaretPosition caretPos = this.textBoxRenderer.render(ctx, textRenderer, box, textBoxCaret, boxScreenX, boxScreenY, scale, showCaret, showSelection);
        if (showCaret && isFocused) {
            int caretScreenX = boxScreenX + (int)Math.round(scale * (double)caretPos.x);
            int caretScreenY = boxScreenY + (int)Math.round(scale * (double)caretPos.y);
            Objects.requireNonNull(textRenderer);
            int caretHeight = (int)Math.round(scale * 9.0 * (double)1.2f * (double)caretPos.textSize);
            this.caretRenderer.renderCaret(ctx, caretScreenX, caretScreenY, caretHeight, isFocused, textBoxCaret.hasSelection());
        }
        textBoxInteraction.addTextBoxRect(boxScreenX, boxScreenY, boxScreenW, boxScreenH, index);
    }

    public void resetCaretBlink() {
        this.caretRenderer.reset();
    }
}

