/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.editor.textbox;

import bookeditor.client.editor.textbox.StyleParams;
import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.data.BookData;
import bookeditor.data.BookDataUtils;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TextBoxEditOps {
    public boolean insertChar(BookData.TextBoxNode box, TextBoxCaret caret, StyleParams style, char ch) {
        int insertIndex;
        String fullText = box.getFullText();
        if (fullText.length() + 1 > 5000) {
            return false;
        }
        if (caret.hasSelection()) {
            this.deleteSelection(box, caret);
        }
        if ((insertIndex = caret.getCharIndex()) < 0) {
            insertIndex = 0;
        }
        if (insertIndex > fullText.length()) {
            insertIndex = fullText.length();
        }
        BookData.TextSegment styleSeg = this.segmentFromStyle(style);
        int currentPos = 0;
        for (int i = 0; i < box.segments.size(); ++i) {
            BookData.TextSegment seg = box.segments.get(i);
            int segLen = seg.text.length();
            if (insertIndex <= currentPos + segLen) {
                int localIndex = insertIndex - currentPos;
                this.insertIntoSegment(box, i, seg, localIndex, styleSeg, style, ch);
                caret.setCharIndex(insertIndex + 1);
                caret.clearSelection();
                this.mergeAdjacentSegments(box);
                return true;
            }
            currentPos += segLen;
        }
        this.appendCharToEnd(box, styleSeg, style, ch);
        caret.setCharIndex(insertIndex + 1);
        caret.clearSelection();
        this.mergeAdjacentSegments(box);
        return true;
    }

    private void insertIntoSegment(BookData.TextBoxNode box, int index, BookData.TextSegment seg, int localIndex, BookData.TextSegment styleSeg, StyleParams style, char ch) {
        if (localIndex == 0 && index > 0 && BookDataUtils.sameStyle(box.segments.get(index - 1), styleSeg)) {
            box.segments.get((int)(index - 1)).text = box.segments.get((int)(index - 1)).text + ch;
        } else if (localIndex == seg.text.length() && BookDataUtils.sameStyle(seg, styleSeg)) {
            seg.text = seg.text + ch;
        } else if (BookDataUtils.sameStyle(seg, styleSeg)) {
            seg.text = seg.text.substring(0, localIndex) + ch + seg.text.substring(localIndex);
        } else {
            String before = seg.text.substring(0, localIndex);
            String after = seg.text.substring(localIndex);
            ArrayList<BookData.TextSegment> newSegs = new ArrayList<BookData.TextSegment>();
            if (!before.isEmpty()) {
                BookData.TextSegment beforeSeg = BookDataUtils.copySegment(seg);
                beforeSeg.text = before;
                newSegs.add(beforeSeg);
            }
            BookData.TextSegment newSeg = this.createSegFromStyle(style, ch);
            newSeg.align = seg.align;
            newSegs.add(newSeg);
            if (!after.isEmpty()) {
                BookData.TextSegment afterSeg = BookDataUtils.copySegment(seg);
                afterSeg.text = after;
                newSegs.add(afterSeg);
            }
            box.segments.remove(index);
            box.segments.addAll(index, newSegs);
        }
    }

    private void appendCharToEnd(BookData.TextBoxNode box, BookData.TextSegment styleSeg, StyleParams style, char ch) {
        if (box.segments.isEmpty() || !BookDataUtils.sameStyle(box.segments.get(box.segments.size() - 1), styleSeg)) {
            BookData.TextSegment newSeg = this.createSegFromStyle(style, ch);
            newSeg.align = 0;
            box.segments.add(newSeg);
        } else {
            box.segments.get((int)(box.segments.size() - 1)).text = box.segments.get((int)(box.segments.size() - 1)).text + ch;
        }
    }

    private BookData.TextSegment createSegFromStyle(StyleParams style, char ch) {
        return new BookData.TextSegment(String.valueOf(ch), style.bold, style.italic, style.underline, style.argb, style.size);
    }

    public void backspace(BookData.TextBoxNode box, TextBoxCaret caret) {
        if (caret.hasSelection()) {
            this.deleteSelection(box, caret);
            return;
        }
        int deleteIndex = caret.getCharIndex();
        if (deleteIndex <= 0) {
            return;
        }
        this.deleteCharAt(box, deleteIndex - 1);
        caret.setCharIndex(deleteIndex - 1);
        this.mergeAdjacentSegments(box);
    }

    public void deleteForward(BookData.TextBoxNode box, TextBoxCaret caret) {
        String fullText;
        if (caret.hasSelection()) {
            this.deleteSelection(box, caret);
            return;
        }
        int deleteIndex = caret.getCharIndex();
        if (deleteIndex >= (fullText = box.getFullText()).length()) {
            return;
        }
        this.deleteCharAt(box, deleteIndex);
        this.mergeAdjacentSegments(box);
    }

    public void applyStyleToSelection(BookData.TextBoxNode box, TextBoxCaret caret, StyleParams style) {
        if (!caret.hasSelection()) {
            return;
        }
        int selStart = caret.selectionStart();
        int selEnd = caret.selectionEnd();
        ArrayList<BookData.TextSegment> newSegments = new ArrayList<BookData.TextSegment>();
        int currentPos = 0;
        for (BookData.TextSegment seg : box.segments) {
            int segStart = currentPos;
            int segEnd = currentPos + seg.text.length();
            if (segEnd <= selStart || segStart >= selEnd) {
                newSegments.add(BookDataUtils.copySegment(seg));
            } else {
                int overlapStart = Math.max(segStart, selStart);
                int overlapEnd = Math.min(segEnd, selEnd);
                if (segStart < overlapStart) {
                    BookData.TextSegment before = BookDataUtils.copySegment(seg);
                    before.text = seg.text.substring(0, overlapStart - segStart);
                    newSegments.add(before);
                }
                BookData.TextSegment styled = new BookData.TextSegment(seg.text.substring(overlapStart - segStart, overlapEnd - segStart), style.bold, style.italic, style.underline, style.argb, style.size);
                styled.align = seg.align;
                newSegments.add(styled);
                if (segEnd > overlapEnd) {
                    BookData.TextSegment after = BookDataUtils.copySegment(seg);
                    after.text = seg.text.substring(overlapEnd - segStart);
                    newSegments.add(after);
                }
            }
            currentPos += seg.text.length();
        }
        box.segments.clear();
        box.segments.addAll(newSegments);
        this.mergeAdjacentSegments(box);
    }

    private void deleteSelection(BookData.TextBoxNode box, TextBoxCaret caret) {
        int selStart = caret.selectionStart();
        int selEnd = caret.selectionEnd();
        for (int i = selEnd - 1; i >= selStart; --i) {
            this.deleteCharAt(box, i);
        }
        caret.setCharIndex(selStart);
        caret.clearSelection();
        this.mergeAdjacentSegments(box);
    }

    private void deleteCharAt(BookData.TextBoxNode box, int index) {
        int currentPos = 0;
        for (int i = 0; i < box.segments.size(); ++i) {
            BookData.TextSegment seg = box.segments.get(i);
            int segLen = seg.text.length();
            if (index < currentPos + segLen) {
                int localIndex = index - currentPos;
                seg.text = seg.text.substring(0, localIndex) + seg.text.substring(localIndex + 1);
                if (seg.text.isEmpty()) {
                    box.segments.remove(i);
                }
                return;
            }
            currentPos += segLen;
        }
    }

    private void mergeAdjacentSegments(BookData.TextBoxNode box) {
        for (int i = 0; i < box.segments.size() - 1; ++i) {
            BookData.TextSegment next;
            BookData.TextSegment current = box.segments.get(i);
            if (!BookDataUtils.sameStyle(current, next = box.segments.get(i + 1))) continue;
            current.text = current.text + next.text;
            box.segments.remove(i + 1);
            --i;
        }
    }

    private BookData.TextSegment segmentFromStyle(StyleParams style) {
        BookData.TextSegment seg = new BookData.TextSegment("", style.bold, style.italic, style.underline, style.argb, style.size);
        seg.align = 0;
        return seg;
    }
}

