/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.editor.tools.DrawingTool;
import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.components.AlignmentSectionBuilder;
import bookeditor.client.gui.components.CanvasSectionBuilder;
import bookeditor.client.gui.components.ContentSectionBuilder;
import bookeditor.client.gui.components.DrawingToolsSectionBuilder;
import bookeditor.client.gui.components.HistorySectionBuilder;
import bookeditor.client.gui.components.PageManagementSectionBuilder;
import bookeditor.client.gui.components.SectionBuildResult;
import bookeditor.client.gui.components.TextSizeSectionBuilder;
import bookeditor.client.gui.components.TextStyleSectionBuilder;
import bookeditor.client.gui.components.ToolbarPager;
import bookeditor.client.gui.components.ToolbarSection;
import bookeditor.client.gui.widget.button.ColorPickerDropdown;
import bookeditor.client.gui.widget.button.IconButton;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.client.gui.widget.field.NumericTextField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class AdaptiveToolbar {
    private final WidgetHost host;
    private final EditorWidget editor;
    private final Runnable onDirty;
    private final IntSupplier getCanvasColor;
    private final Consumer<Integer> setCanvasColor;
    private final Runnable openInsertDialog;
    private final Runnable createNewPage;
    private final Runnable deleteCurrentPage;
    private final Runnable signAction;
    private final int x;
    private final int y;
    private final int btnH;
    private final int gap;
    private final int availableWidth;
    private ToolbarPager pager;
    private final List<ToolbarSection> sections = new ArrayList<ToolbarSection>();
    private IconButton boldBtn;
    private IconButton italicBtn;
    private IconButton underlineBtn;
    private NumericTextField sizeField;
    private ColorPickerDropdown textColorBtn;
    private ColorPickerDropdown canvasColorBtn;
    private final Map<DrawingTool, IconButton> toolButtonMap = new HashMap<DrawingTool, IconButton>();
    private IconButton textboxBtn;
    private IconButton imageBtn;

    public AdaptiveToolbar(WidgetHost host, EditorWidget editor, Runnable onDirty, IntSupplier getCanvasColor, Consumer<Integer> setCanvasColor, Runnable openInsertDialog, Runnable createNewPage, Runnable deleteCurrentPage, Runnable signAction, int x, int y, int btnH, int gap, int availableWidth) {
        this.host = host;
        this.editor = editor;
        this.onDirty = onDirty;
        this.getCanvasColor = getCanvasColor;
        this.setCanvasColor = setCanvasColor;
        this.openInsertDialog = openInsertDialog;
        this.createNewPage = createNewPage;
        this.deleteCurrentPage = deleteCurrentPage;
        this.signAction = signAction;
        this.x = x;
        this.y = y;
        this.btnH = btnH;
        this.gap = gap;
        this.availableWidth = availableWidth;
    }

    public void build() {
        this.pager = new ToolbarPager(this.host, this.x, this.y, this.btnH, this.gap, this.availableWidth, p -> {
            this.refreshFormatButtons();
            this.updateToolHighlights();
        });
        this.createSections();
        this.pager.setSections(this.sections);
        this.pager.showPage(0);
    }

    private void createSections() {
        this.sections.clear();
        SectionBuildResult res = new HistorySectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        res = new TextStyleSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        this.boldBtn = (IconButton)((Object)res.get("boldBtn"));
        this.italicBtn = (IconButton)((Object)res.get("italicBtn"));
        this.underlineBtn = (IconButton)((Object)res.get("underlineBtn"));
        this.textColorBtn = (ColorPickerDropdown)((Object)res.get("textColorBtn"));
        res = new TextSizeSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        this.sizeField = (NumericTextField)((Object)res.get("sizeField"));
        res = new AlignmentSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        res = new ContentSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        Object o = res.get("textboxBtn");
        if (o instanceof IconButton) {
            this.textboxBtn = (IconButton)((Object)o);
        }
        if ((o = res.get("imageBtn")) instanceof IconButton) {
            this.imageBtn = (IconButton)((Object)o);
        }
        res = new DrawingToolsSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        o = res.get("brushBtn");
        if (o instanceof IconButton) {
            this.toolButtonMap.put(DrawingTool.BRUSH, (IconButton)((Object)o));
        }
        if ((o = res.get("sprayBtn")) instanceof IconButton) {
            this.toolButtonMap.put(DrawingTool.SPRAY, (IconButton)((Object)o));
        }
        if ((o = res.get("lineBtn")) instanceof IconButton) {
            this.toolButtonMap.put(DrawingTool.LINE, (IconButton)((Object)o));
        }
        if ((o = res.get("rectangleBtn")) instanceof IconButton) {
            this.toolButtonMap.put(DrawingTool.RECTANGLE, (IconButton)((Object)o));
        }
        if ((o = res.get("circleBtn")) instanceof IconButton) {
            this.toolButtonMap.put(DrawingTool.CIRCLE, (IconButton)((Object)o));
        }
        if ((o = res.get("eraserBtn")) instanceof IconButton) {
            this.toolButtonMap.put(DrawingTool.ERASER, (IconButton)((Object)o));
        }
        res = new CanvasSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
        this.canvasColorBtn = (ColorPickerDropdown)((Object)res.get("canvasColorBtn"));
        res = new PageManagementSectionBuilder().build(this.host, this.editor, this.onDirty, this.getCanvasColor, this.setCanvasColor, this.openInsertDialog, this.createNewPage, this.deleteCurrentPage, this.signAction, this.btnH);
        this.sections.add(res.section);
    }

    private void updateToolHighlights() {
        DrawingTool currentTool = this.editor.getCurrentDrawingTool();
        for (Map.Entry<DrawingTool, IconButton> entry : this.toolButtonMap.entrySet()) {
            IconButton btn = entry.getValue();
            boolean selected = entry.getKey() == currentTool;
            btn.setSelected(selected);
        }
    }

    public void setVisible(boolean visible) {
        if (this.pager != null) {
            this.pager.setVisible(visible);
        }
    }

    public void syncWithEditor() {
        this.editor.syncStylesFromSelection();
        this.refreshFormatButtons();
        this.updateToolHighlights();
        this.updateLimitButtons();
    }

    private void updateLimitButtons() {
        if (this.editor == null) {
            return;
        }
        boolean editable = this.editor.isEditable();
        int nodeCount = this.editor.getPageNodeCount();
        int strokeCount = this.editor.getPageStrokeCount();
        boolean canAddNode = editable && nodeCount < 512;
        boolean canAddStroke = editable && strokeCount < 1024;
        DrawingTool currentTool = this.editor.getCurrentDrawingTool();
        if (this.textboxBtn != null) {
            boolean bl = this.textboxBtn.field_22763 = canAddNode || this.editor.isTextBoxToolActive();
            if (!this.textboxBtn.field_22763) {
                this.textboxBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Node limit reached")));
            }
        }
        if (this.imageBtn != null) {
            this.imageBtn.field_22763 = canAddNode;
            if (!this.imageBtn.field_22763) {
                this.imageBtn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Node limit reached")));
            }
        }
        for (Map.Entry<DrawingTool, IconButton> entry : this.toolButtonMap.entrySet()) {
            IconButton b = entry.getValue();
            DrawingTool dt = entry.getKey();
            boolean bl = b.field_22763 = canAddStroke || currentTool != null && currentTool == dt;
            if (b.field_22763) continue;
            b.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Stroke limit reached")));
        }
    }

    public void refreshFormatButtons() {
        if (this.boldBtn != null) {
            this.boldBtn.setSelected(this.editor.isBold());
        }
        if (this.italicBtn != null) {
            this.italicBtn.setSelected(this.editor.isItalic());
        }
        if (this.underlineBtn != null) {
            this.underlineBtn.setSelected(this.editor.isUnderline());
        }
        if (this.sizeField != null && this.sizeField.field_22764) {
            this.sizeField.method_1852(String.format("%.1f", Float.valueOf(this.editor.getSize())));
        }
        if (this.textColorBtn != null) {
            this.textColorBtn.setArgb(this.editor.getColor());
        }
    }

    public void updateCanvasColor(int color) {
        if (this.canvasColorBtn != null) {
            this.canvasColorBtn.setArgb(color);
        }
    }
}

