/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.components;

import bookeditor.client.gui.base.WidgetHost;
import bookeditor.client.gui.components.SectionBuildResult;
import bookeditor.client.gui.components.ToolbarSection;
import bookeditor.client.gui.components.ToolbarSectionBuilder;
import bookeditor.client.gui.widget.button.IconButton;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.client.gui.widget.field.NumericTextField;
import bookeditor.client.util.IconUtils;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class TextSizeSectionBuilder
implements ToolbarSectionBuilder {
    @Override
    public SectionBuildResult build(WidgetHost host, EditorWidget editor, Runnable onDirty, IntSupplier getCanvasColor, Consumer<Integer> setCanvasColor, Runnable openInsertDialog, Runnable createNewPage, Runnable deleteCurrentPage, Runnable signAction, int btnH) {
        ToolbarSection section = new ToolbarSection("Size");
        IconButton decreaseBtn = new IconButton(0, 0, 18, btnH, IconUtils.ICON_DECREASE_SIZE, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.decrease_size"), b -> {
            float currentSize = editor.getSize();
            float newSize = Math.max(0.5f, currentSize - 0.1f);
            editor.setSize(newSize);
            editor.applyStyleToSelection();
            onDirty.run();
        });
        decreaseBtn.field_22764 = false;
        host.addDrawable(decreaseBtn);
        section.addWidget((Object)decreaseBtn, 18);
        NumericTextField sizeField = new NumericTextField(host.getTextRenderer(), 0, 0, 40, btnH, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.text_size"));
        sizeField.method_1852("1.0");
        sizeField.setOnEnterPressed(() -> {
            try {
                float s = Float.parseFloat(sizeField.method_1882().trim());
                s = Math.max(0.5f, Math.min(3.0f, s));
                editor.setSize(s);
                editor.applyStyleToSelection();
                sizeField.method_1852(String.format("%.1f", Float.valueOf(s)));
                onDirty.run();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        host.addDrawable(sizeField);
        section.addWidget((Object)sizeField, 40);
        IconButton increaseBtn = new IconButton(0, 0, 18, btnH, IconUtils.ICON_INCREASE_SIZE, (class_2561)class_2561.method_43471((String)"tooltip.bookeditor.increase_size"), b -> {
            float currentSize = editor.getSize();
            float newSize = Math.min(3.0f, currentSize + 0.1f);
            editor.setSize(newSize);
            editor.applyStyleToSelection();
            onDirty.run();
        });
        increaseBtn.field_22764 = false;
        host.addDrawable(increaseBtn);
        section.addWidget((Object)increaseBtn, 18);
        SectionBuildResult res = new SectionBuildResult(section);
        res.with("decreaseBtn", (Object)decreaseBtn).with("sizeField", (Object)sizeField).with("increaseBtn", (Object)increaseBtn);
        return res;
    }
}

