/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button;

import bookeditor.client.gui.widget.button.colorpicker.ColorPickerInputHandler;
import bookeditor.client.gui.widget.button.colorpicker.ColorPickerRenderer;
import bookeditor.client.gui.widget.button.colorpicker.ColorPickerState;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class ColorPickerDropdown
extends class_339 {
    private final ColorPickerState state;
    private final ColorPickerRenderer renderer;
    private final ColorPickerInputHandler inputHandler;
    private final Consumer<Integer> onColorChange;

    public ColorPickerDropdown(int x, int y, Consumer<Integer> onColorChange, int initialArgb) {
        super(x, y, 20, 18, (class_2561)class_2561.method_43470((String)""));
        this.onColorChange = onColorChange;
        this.state = new ColorPickerState(initialArgb);
        this.renderer = new ColorPickerRenderer();
        this.inputHandler = new ColorPickerInputHandler(this.state, onColorChange);
    }

    public void setArgb(int argb) {
        this.state.updateFromArgb(argb);
    }

    public int getArgb() {
        return this.state.argb;
    }

    public boolean isExpanded() {
        return this.state.expanded;
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.state.lastFrameTime) / 1000.0f;
        this.state.lastFrameTime = currentTime;
        this.state.updateHoverProgress(this.method_49606(), deltaTime);
        this.renderer.renderButton(ctx, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.state);
    }

    public void renderDropdown(class_332 ctx, int mouseX, int mouseY) {
        if (!this.state.expanded) {
            return;
        }
        this.state.updateCursorBlink();
        int dropX = this.method_46426();
        int dropY = this.method_46427() + this.field_22759 + 2;
        this.renderer.renderDropdown(ctx, dropX, dropY, this.state);
    }

    public void method_25348(double mouseX, double mouseY) {
        if (!this.state.expanded) {
            this.state.expanded = true;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.state.expanded) {
            if (this.method_25405(mouseX, mouseY)) {
                this.state.expanded = true;
                return true;
            }
            return false;
        }
        int dropX = this.method_46426();
        int dropY = this.method_46427() + this.field_22759 + 2;
        return this.inputHandler.handleMouseClick(mouseX, mouseY, dropX, dropY);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.state.expanded) {
            return false;
        }
        int dropX = this.method_46426();
        int dropY = this.method_46427() + this.field_22759 + 2;
        return this.inputHandler.handleMouseDrag(mouseX, mouseY, dropX, dropY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.inputHandler.handleMouseRelease();
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.inputHandler.handleKeyPress(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.inputHandler.handleCharTyped(chr, modifiers);
    }

    protected void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43471((String)"narrator.select.color"));
    }
}

