/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class CustomButton
extends class_4185 {
    private float hoverProgress = 0.0f;
    private long lastFrameTime = System.currentTimeMillis();
    private static final int PRIMARY_COLOR = -988964;
    private static final int DISABLED_COLOR = -2832200;
    private static final int BORDER_NORMAL = -7631989;
    private static final int BORDER_HOVER = -1525684;
    private static final int TEXT_COLOR = -16777216;
    private static final int TEXT_DISABLED = -9740461;
    private static final int SHADOW_COLOR = 0x441E1E1E;

    public CustomButton(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
        super(x, y, width, height, message, onPress, field_40754);
    }

    public CustomButton(int x, int y, int width, int height, class_2561 message, class_2561 tooltip, class_4185.class_4241 onPress) {
        this(x, y, width, height, message, onPress);
        this.method_47400(class_7919.method_47407((class_2561)tooltip));
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
        this.lastFrameTime = currentTime;
        boolean isHovering = this.method_49606();
        if (isHovering && this.hoverProgress < 1.0f) {
            this.hoverProgress = Math.min(1.0f, this.hoverProgress + deltaTime * 10.0f);
        } else if (!isHovering && this.hoverProgress > 0.0f) {
            this.hoverProgress = Math.max(0.0f, this.hoverProgress - deltaTime * 10.0f);
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int w = this.field_22758;
        int h = this.field_22759;
        if (this.field_22763) {
            ctx.method_25294(x + 1, y + h, x + w, y + h + 2, 0x441E1E1E);
            ctx.method_25294(x, y, x + w, y + h, -988964);
            int topHighlight = this.addAlpha(-1, 0.3f);
            ctx.method_25294(x + 1, y + 1, x + w - 1, y + 2, topHighlight);
            int bottomShadow = this.addAlpha(-16777216, 0.15f);
            ctx.method_25294(x + 1, y + h - 2, x + w - 1, y + h - 1, bottomShadow);
            int borderColor = this.interpolateColor(-7631989, -1525684, this.hoverProgress);
            ctx.method_25294(x, y, x + w, y + 1, borderColor);
            ctx.method_25294(x, y + h - 1, x + w, y + h, borderColor);
            ctx.method_25294(x, y, x + 1, y + h, borderColor);
            ctx.method_25294(x + w - 1, y, x + w, y + h, borderColor);
        } else {
            ctx.method_25294(x, y, x + w, y + h, -2832200);
            int borderColor = -7631989;
            ctx.method_25294(x, y, x + w, y + 1, borderColor);
            ctx.method_25294(x, y + h - 1, x + w, y + h, borderColor);
            ctx.method_25294(x, y, x + 1, y + h, borderColor);
            ctx.method_25294(x + w - 1, y, x + w, y + h, borderColor);
        }
        int textX = x + w / 2;
        int textY = y + (h - 8) / 2;
        int textWidth = this.getTextRenderer().method_27525((class_5348)this.method_25369());
        ctx.method_51439(this.getTextRenderer(), this.method_25369(), textX - textWidth / 2, textY, this.field_22763 ? -16777216 : -9740461, false);
    }

    private int interpolateColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int addAlpha(int color, float alpha) {
        int a = (int)(255.0f * alpha);
        return a << 24 | color & 0xFFFFFF;
    }

    private class_327 getTextRenderer() {
        return class_310.method_1551().field_1772;
    }
}

