/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

@Environment(value=EnvType.CLIENT)
public class IconButton
extends class_4185 {
    private final class_2960 iconTexture;
    private boolean selected = false;
    private float hoverProgress = 0.0f;
    private long lastFrameTime = System.currentTimeMillis();
    private static final int BG_COLOR = -988964;
    private static final int BG_SELECTED = -1525684;
    private static final int BORDER_NORMAL = -7631989;
    private static final int BORDER_HOVER = -1525684;
    private static final int SHADOW = 0x331E1E1E;

    public IconButton(int x, int y, int width, int height, class_2960 iconTexture, class_2561 tooltip, class_4185.class_4241 onPress) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), onPress, field_40754);
        this.iconTexture = iconTexture;
        this.method_47400(class_7919.method_47407((class_2561)tooltip));
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean method_25367() {
        return this.selected;
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastFrameTime) / 1000.0f;
        this.lastFrameTime = currentTime;
        boolean isHovering = this.method_49606();
        if (isHovering && this.hoverProgress < 1.0f) {
            this.hoverProgress = Math.min(1.0f, this.hoverProgress + deltaTime * 10.0f);
        } else if (!isHovering && this.hoverProgress > 0.0f) {
            this.hoverProgress = Math.max(0.0f, this.hoverProgress - deltaTime * 10.0f);
        }
        int x = this.method_46426();
        int y = this.method_46427();
        int w = this.field_22758;
        int h = this.field_22759;
        ctx.method_25294(x + 1, y + h, x + w - 1, y + h + 1, 0x331E1E1E);
        int bgColor = this.selected ? -1525684 : -988964;
        ctx.method_25294(x, y, x + w, y + h, bgColor);
        int topHighlight = this.addAlpha(-1, 0.3f);
        ctx.method_25294(x + 1, y + 1, x + w - 1, y + 2, topHighlight);
        int bottomShadow = this.addAlpha(-16777216, 0.15f);
        ctx.method_25294(x + 1, y + h - 2, x + w - 1, y + h - 1, bottomShadow);
        int borderColor = this.selected ? -7631989 : this.interpolateColor(-7631989, -1525684, this.hoverProgress);
        int bw = 1;
        ctx.method_25294(x, y, x + w, y + bw, borderColor);
        ctx.method_25294(x, y + h - bw, x + w, y + h, borderColor);
        ctx.method_25294(x, y, x + bw, y + h, borderColor);
        ctx.method_25294(x + w - bw, y, x + w, y + h, borderColor);
        int iconSize = 16;
        int renderSize = (int)((double)this.field_22758 * 0.7);
        int iconX = x + (w - renderSize) / 2;
        int iconY = y + (h - renderSize) / 2;
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416((float)iconX, (float)iconY, 0.0f);
        float scale = (float)renderSize / (float)iconSize;
        ctx.method_51448().method_22905(scale, scale, 1.0f);
        int tint = this.field_22763 ? -1 : -8355712;
        ctx.method_51422((float)(tint >> 16 & 0xFF) / 255.0f, (float)(tint >> 8 & 0xFF) / 255.0f, (float)(tint & 0xFF) / 255.0f, (float)(tint >> 24 & 0xFF) / 255.0f);
        ctx.method_25290(this.iconTexture, 0, 0, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        ctx.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        ctx.method_51448().method_22909();
    }

    private int interpolateColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int addAlpha(int color, float alpha) {
        int a = (int)(255.0f * alpha);
        return a << 24 | color & 0xFFFFFF;
    }
}

