/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.button.colorpicker;

import bookeditor.client.gui.widget.button.colorpicker.ColorConverter;
import bookeditor.client.gui.widget.button.colorpicker.ColorPickerConstants;
import bookeditor.client.gui.widget.button.colorpicker.ColorPickerState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ColorPickerRenderer {
    public void renderButton(class_332 ctx, int x, int y, int width, int height, ColorPickerState state) {
        ctx.method_25294(x + 1, y + height, x + width - 1, y + height + 1, 0x33000000);
        ctx.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, state.argb);
        int borderColor = ColorConverter.interpolateColor(-7631989, -1525684, state.hoverProgress);
        ctx.method_25294(x, y, x + width, y + 1, borderColor);
        ctx.method_25294(x, y + height - 1, x + width, y + height, borderColor);
        ctx.method_25294(x, y, x + 1, y + height, borderColor);
        ctx.method_25294(x + width - 1, y, x + width, y + height, borderColor);
        int topGradient = ColorConverter.addAlpha(-1, 0.2f * (1.0f + state.hoverProgress * 0.3f));
        ctx.method_25294(x + 1, y + 1, x + width - 1, y + height / 2, topGradient);
    }

    public void renderDropdown(class_332 ctx, int dropX, int dropY, ColorPickerState state) {
        int totalWidth = ColorPickerConstants.calculateTotalWidth();
        int totalHeight = ColorPickerConstants.calculateTotalHeight();
        ctx.method_51448().method_22903();
        ctx.method_51448().method_46416(0.0f, 0.0f, 300.0f);
        ctx.method_25294(dropX - 1, dropY - 1, dropX + totalWidth + 1, dropY + totalHeight + 1, -13158601);
        ctx.method_25294(dropX, dropY, dropX + totalWidth, dropY + totalHeight, -988964);
        int paletteX = dropX + 2;
        int paletteY = dropY + 2;
        this.renderSatBrightPalette(ctx, paletteX, paletteY, state);
        int hueX = paletteX + 124 + 2;
        this.renderHueBar(ctx, hueX, paletteY, state);
        int hexY = paletteY + 80 + 2;
        this.renderHexField(ctx, paletteX, hexY, state);
        this.renderPreview(ctx, paletteX + 80 + 2, hexY, state);
        ctx.method_51448().method_22909();
    }

    private void renderSatBrightPalette(class_332 ctx, int x, int y, ColorPickerState state) {
        for (int py = 0; py < 80; ++py) {
            for (int px = 0; px < 124; ++px) {
                float sat = (float)px / 123.0f;
                float bright = 1.0f - (float)py / 79.0f;
                int color = ColorConverter.hsbToArgb(state.hue, sat, bright);
                ctx.method_25294(x + px, y + py, x + px + 1, y + py + 1, color);
            }
        }
        ctx.method_25294(x - 1, y - 1, x + 124 + 1, y, -13158601);
        ctx.method_25294(x - 1, y + 80, x + 124 + 1, y + 80 + 1, -13158601);
        ctx.method_25294(x - 1, y, x, y + 80, -13158601);
        ctx.method_25294(x + 124, y, x + 124 + 1, y + 80, -13158601);
        int markerX = x + (int)(state.saturation * 123.0f);
        int markerY = y + (int)((1.0f - state.brightness) * 79.0f);
        ctx.method_25294(markerX - 3, markerY - 1, markerX + 4, markerY, -1);
        ctx.method_25294(markerX - 3, markerY + 1, markerX + 4, markerY + 2, -1);
        ctx.method_25294(markerX - 1, markerY - 3, markerX, markerY + 4, -1);
        ctx.method_25294(markerX + 1, markerY - 3, markerX + 2, markerY + 4, -1);
        ctx.method_25294(markerX - 4, markerY - 1, markerX - 3, markerY + 2, -16777216);
        ctx.method_25294(markerX + 4, markerY - 1, markerX + 5, markerY + 2, -16777216);
        ctx.method_25294(markerX - 1, markerY - 4, markerX + 2, markerY - 3, -16777216);
        ctx.method_25294(markerX - 1, markerY + 4, markerX + 2, markerY + 5, -16777216);
    }

    private void renderHueBar(class_332 ctx, int x, int y, ColorPickerState state) {
        for (int py = 0; py < 80; ++py) {
            float h = (float)py / 79.0f;
            int color = ColorConverter.hsbToArgb(h, 1.0f, 1.0f);
            ctx.method_25294(x, y + py, x + 12, y + py + 1, color);
        }
        ctx.method_25294(x - 1, y - 1, x + 12 + 1, y, -13158601);
        ctx.method_25294(x - 1, y + 80, x + 12 + 1, y + 80 + 1, -13158601);
        ctx.method_25294(x - 1, y, x, y + 80, -13158601);
        ctx.method_25294(x + 12, y, x + 12 + 1, y + 80, -13158601);
        int markerY = y + (int)(state.hue * 79.0f);
        ctx.method_25294(x - 2, markerY - 1, x + 12 + 2, markerY + 2, -1);
        ctx.method_25294(x - 3, markerY - 2, x + 12 + 3, markerY - 1, -16777216);
        ctx.method_25294(x - 3, markerY + 2, x + 12 + 3, markerY + 3, -16777216);
    }

    private void renderHexField(class_332 ctx, int x, int y, ColorPickerState state) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int borderColor = state.hexFieldFocused ? -13158601 : -7631989;
        int bgColor = -988964;
        ctx.method_25294(x, y, x + 80, y + 18, borderColor);
        ctx.method_25294(x + 1, y + 1, x + 80 - 1, y + 18 - 1, bgColor);
        String displayText = "#" + state.hexInput;
        ctx.method_51439(textRenderer, (class_2561)class_2561.method_43470((String)displayText), x + 4, y + 5, -16777216, false);
        if (state.hexFieldFocused && state.cursorVisible) {
            String beforeCursor = "#" + state.hexInput.substring(0, Math.min(state.cursorPos, state.hexInput.length()));
            int cursorX = x + 4 + textRenderer.method_1727(beforeCursor);
            ctx.method_25294(cursorX, y + 3, cursorX + 1, y + 18 - 3, -16777216);
        }
    }

    private void renderPreview(class_332 ctx, int x, int y, ColorPickerState state) {
        ctx.method_25294(x, y, x + 42, y + 18, -13158601);
        ctx.method_25294(x + 1, y + 1, x + 42 - 1, y + 18 - 1, state.argb);
    }
}

