/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.editor.input.EditorInputHandler;
import bookeditor.client.editor.input.EditorMouseHandler;
import bookeditor.client.editor.interaction.ImageInteraction;
import bookeditor.client.editor.interaction.TextBoxInteraction;
import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.render.EditorRenderer;
import bookeditor.client.editor.render.TextBoxRenderer;
import bookeditor.client.editor.textbox.TextBoxCaret;
import bookeditor.client.editor.textbox.TextBoxEditOps;
import bookeditor.client.editor.tools.AdvancedDrawingTool;
import bookeditor.client.editor.tools.EraserTool;
import bookeditor.client.editor.tools.TextBoxCreationTool;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.data.BookData;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_327;

@Environment(value=EnvType.CLIENT)
public class EditorState {
    public static final int PAD_OUT = 8;
    public static final int PAD_IN = 8;
    public static final int LOGICAL_W = 960;
    public static final int LOGICAL_H = 600;
    public static final int MAX_TEXTBOX_CHARS = 5000;
    public final class_327 textRenderer;
    public final Consumer<String> onImageUrlSeen;
    public final Runnable onDirty;
    public boolean editable;
    public BookData.Page page;
    public EditorMode mode = EditorMode.OBJECT_MODE;
    public boolean bold;
    public boolean italic;
    public boolean underline;
    public int argb = -14671840;
    public float size = 1.0f;
    public int textBoxBgColor = 0xFFFFFF;
    public String plankType = "minecraft:dark_oak_planks";
    public int scrollY = 0;
    public String clipboard = "";
    public float userZoom = 1.0f;
    public int panOffsetX = 0;
    public int panOffsetY = 0;
    public boolean isPanning = false;
    public int panStartMouseX = 0;
    public int panStartMouseY = 0;
    public int panStartOffsetX = 0;
    public int panStartOffsetY = 0;
    private float smoothZoom = 1.0f;
    private float smoothPanX = 0.0f;
    private float smoothPanY = 0.0f;
    private static final float SMOOTH_FACTOR = 0.15f;
    private int cachedWidgetX = -1;
    private int cachedWidgetY = -1;
    private int cachedWidgetW = -1;
    private int cachedWidgetH = -1;
    private double cachedBaseScale = -1.0;
    private int cachedVisualW = -1;
    private int cachedVisualH = -1;
    private int cachedVisualLeft = -1;
    private int cachedVisualTop = -1;
    public final TextBoxCaret textBoxCaret = new TextBoxCaret();
    public final ImageInteraction imageInteraction = new ImageInteraction();
    public final TextBoxInteraction textBoxInteraction = new TextBoxInteraction();
    public final TextBoxCreationTool textBoxCreationTool = new TextBoxCreationTool();
    public final EraserTool eraserTool = new EraserTool();
    public final AdvancedDrawingTool drawingTool = new AdvancedDrawingTool();
    public final TextBoxRenderer textBoxRenderer = new TextBoxRenderer();
    public final TextBoxEditOps textBoxOps = new TextBoxEditOps();
    public final EditorRenderer editorRenderer = new EditorRenderer();
    public final EditorInputHandler inputHandler = new EditorInputHandler(this);
    public final EditorMouseHandler mouseHandler = new EditorMouseHandler();
    private final EditorWidget widget;
    private String transientMessage = null;
    private long transientExpiryMillis = 0L;

    public EditorState(class_327 textRenderer, boolean editable, Consumer<String> onImageUrlSeen, Runnable onDirty, EditorWidget widget) {
        this.textRenderer = textRenderer;
        this.editable = editable;
        this.onImageUrlSeen = onImageUrlSeen;
        this.onDirty = onDirty;
        this.widget = widget;
    }

    public void setHeight(int height) {
        this.widget.setWidgetHeight(Math.max(40, height));
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setContent(BookData.Page page) {
        this.page = page;
        this.mode = EditorMode.OBJECT_MODE;
        this.textBoxCaret.reset();
        this.textBoxInteraction.clearSelection();
        this.imageInteraction.clearSelection();
        this.textBoxCreationTool.deactivate();
        this.drawingTool.setActive(false);
        this.eraserTool.setActive(false);
        this.scrollY = 0;
    }

    private void updateCache() {
        int wx = this.widget.method_46426();
        int wy = this.widget.method_46427();
        int ww = this.widget.method_25368();
        int wh = this.widget.method_25364();
        if (wx != this.cachedWidgetX || wy != this.cachedWidgetY || ww != this.cachedWidgetW || wh != this.cachedWidgetH) {
            this.cachedWidgetX = wx;
            this.cachedWidgetY = wy;
            this.cachedWidgetW = ww;
            this.cachedWidgetH = wh;
            int iw = Math.max(0, ww - 16);
            int ih = Math.max(0, wh - 16);
            double sw = (double)iw / 976.0;
            double sh = (double)ih / 616.0;
            this.cachedBaseScale = Math.max(0.1, Math.min(sw, sh));
            this.cachedVisualW = (int)Math.floor(this.cachedBaseScale * 976.0);
            this.cachedVisualH = (int)Math.floor(this.cachedBaseScale * 616.0);
            this.cachedVisualLeft = wx + 8 + (iw - this.cachedVisualW) / 2;
            this.cachedVisualTop = wy + 8 + (ih - this.cachedVisualH) / 2;
        }
    }

    public void updateSmooth() {
        this.smoothZoom += (this.userZoom - this.smoothZoom) * 0.15f;
        this.smoothPanX += ((float)this.panOffsetX - this.smoothPanX) * 0.15f;
        this.smoothPanY += ((float)this.panOffsetY - this.smoothPanY) * 0.15f;
        if (Math.abs(this.smoothZoom - this.userZoom) < 0.001f) {
            this.smoothZoom = this.userZoom;
        }
        if (Math.abs(this.smoothPanX - (float)this.panOffsetX) < 0.5f) {
            this.smoothPanX = this.panOffsetX;
        }
        if (Math.abs(this.smoothPanY - (float)this.panOffsetY) < 0.5f) {
            this.smoothPanY = this.panOffsetY;
        }
    }

    public double baseScale() {
        this.updateCache();
        return this.cachedBaseScale;
    }

    public double scale() {
        return this.baseScale() * (double)this.smoothZoom;
    }

    public int canvasVisualWidth() {
        this.updateCache();
        return this.cachedVisualW;
    }

    public int canvasVisualHeight() {
        this.updateCache();
        return this.cachedVisualH;
    }

    public int canvasVisualLeft() {
        this.updateCache();
        return this.cachedVisualLeft;
    }

    public int canvasVisualTop() {
        this.updateCache();
        return this.cachedVisualTop;
    }

    public int canvasScreenLeft() {
        double sc = this.scale();
        int zoomedW = (int)Math.floor(sc * 976.0);
        int centerOffsetX = (this.canvasVisualWidth() - zoomedW) / 2;
        return this.canvasVisualLeft() + centerOffsetX + (int)this.smoothPanX;
    }

    public int canvasScreenTop() {
        double sc = this.scale();
        int zoomedH = (int)Math.floor(sc * 616.0);
        int centerOffsetY = (this.canvasVisualHeight() - zoomedH) / 2;
        return this.canvasVisualTop() + centerOffsetY + (int)this.smoothPanY;
    }

    public int contentScreenLeft() {
        return this.canvasScreenLeft() + (int)Math.round(this.scale() * 8.0);
    }

    public int contentScreenTop() {
        return this.canvasScreenTop() + (int)Math.round(this.scale() * 8.0);
    }

    public void setUserZoom(float zoom) {
        this.userZoom = Math.max(1.0f, Math.min(5.0f, zoom));
        this.clampPanOffset();
    }

    public void clampPanOffset() {
        if (this.userZoom <= 1.0f) {
            this.panOffsetX = 0;
            this.panOffsetY = 0;
            return;
        }
        int zoomedW = (int)Math.floor(this.scale() * 976.0);
        int zoomedH = (int)Math.floor(this.scale() * 616.0);
        int maxPanX = Math.max(0, (zoomedW - this.canvasVisualWidth()) / 2);
        int maxPanY = Math.max(0, (zoomedH - this.canvasVisualHeight()) / 2);
        this.panOffsetX = Math.max(-maxPanX, Math.min(maxPanX, this.panOffsetX));
        this.panOffsetY = Math.max(-maxPanY, Math.min(maxPanY, this.panOffsetY));
    }

    public boolean canPan() {
        return this.userZoom > 1.0f && !this.drawingTool.isActive() && !this.eraserTool.isActive() && !this.textBoxCreationTool.isActive();
    }

    public EditorWidget getWidget() {
        return this.widget;
    }

    public void setPlankType(String plankType) {
        this.plankType = plankType != null ? plankType : "minecraft:dark_oak_planks";
    }

    public void showTransientMessage(String msg, long durationMillis) {
        this.transientMessage = msg;
        this.transientExpiryMillis = System.currentTimeMillis() + durationMillis;
    }

    public String getTransientMessage() {
        if (this.transientMessage == null) {
            return null;
        }
        if (System.currentTimeMillis() > this.transientExpiryMillis) {
            this.transientMessage = null;
            return null;
        }
        return this.transientMessage;
    }
}

