/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.textbox.StyleParams;
import bookeditor.client.gui.widget.editor.EditorHistoryManager;
import bookeditor.client.gui.widget.editor.EditorState;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class EditorStyleManager {
    private final EditorState state;
    private final EditorHistoryManager historyManager;

    public EditorStyleManager(EditorState state, EditorHistoryManager historyManager) {
        this.state = state;
        this.historyManager = historyManager;
    }

    public void setBold(boolean bold) {
        this.state.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.state.italic = italic;
    }

    public void setUnderline(boolean underline) {
        this.state.underline = underline;
    }

    public void setColor(int argb) {
        this.state.argb = argb;
    }

    public void setSize(float size) {
        this.state.size = size;
    }

    public void setTextBoxBgColor(int argb) {
        BookData.Node node;
        this.state.textBoxBgColor = argb;
        if (this.state.mode == EditorMode.OBJECT_MODE && this.state.textBoxInteraction.getSelectedTextBoxIndex() >= 0 && (node = this.state.page.nodes.get(this.state.textBoxInteraction.getSelectedTextBoxIndex())) instanceof BookData.TextBoxNode) {
            BookData.TextBoxNode box = (BookData.TextBoxNode)node;
            this.historyManager.pushSnapshotOnce();
            box.bgArgb = argb;
            this.historyManager.notifyDirty();
        }
    }

    public void setAlignment(int align) {
        if (!this.state.editable || this.state.page == null || this.state.mode != EditorMode.TEXT_MODE) {
            return;
        }
        if (this.state.textBoxInteraction.getSelectedTextBoxIndex() < 0) {
            return;
        }
        BookData.Node node = this.state.page.nodes.get(this.state.textBoxInteraction.getSelectedTextBoxIndex());
        if (!(node instanceof BookData.TextBoxNode)) {
            return;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)node;
        this.historyManager.pushSnapshotOnce();
        for (BookData.TextSegment seg : box.segments) {
            seg.align = align;
        }
        this.historyManager.notifyDirty();
    }

    public void applyStyleToSelection() {
        if (!this.state.editable || this.state.page == null || this.state.mode != EditorMode.TEXT_MODE) {
            return;
        }
        if (this.state.textBoxInteraction.getSelectedTextBoxIndex() < 0) {
            return;
        }
        BookData.Node node = this.state.page.nodes.get(this.state.textBoxInteraction.getSelectedTextBoxIndex());
        if (!(node instanceof BookData.TextBoxNode)) {
            return;
        }
        BookData.TextBoxNode box = (BookData.TextBoxNode)node;
        if (this.state.textBoxCaret.hasSelection()) {
            this.historyManager.pushSnapshotOnce();
            this.state.textBoxOps.applyStyleToSelection(box, this.state.textBoxCaret, this.style());
            this.historyManager.notifyDirty();
        }
    }

    public void copySelection() {
        BookData.Node node;
        int selectedIdx;
        if (this.state.textBoxCaret.hasSelection() && (selectedIdx = this.state.textBoxInteraction.getSelectedTextBoxIndex()) >= 0 && selectedIdx < this.state.page.nodes.size() && (node = this.state.page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode) {
            BookData.TextBoxNode box = (BookData.TextBoxNode)node;
            int selStart = this.state.textBoxCaret.selectionStart();
            int selEnd = this.state.textBoxCaret.selectionEnd();
            this.state.clipboard = box.getFullText().substring(selStart, Math.min(selEnd, box.getFullText().length()));
        }
    }

    public void cutSelection() {
        this.copySelection();
        if (this.state.textBoxCaret.hasSelection()) {
            BookData.Node node;
            this.historyManager.pushSnapshotOnce();
            int selectedIdx = this.state.textBoxInteraction.getSelectedTextBoxIndex();
            if (selectedIdx >= 0 && selectedIdx < this.state.page.nodes.size() && (node = this.state.page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode) {
                BookData.TextBoxNode box = (BookData.TextBoxNode)node;
                this.state.textBoxOps.backspace(box, this.state.textBoxCaret);
            }
            this.historyManager.notifyDirty();
        }
    }

    public void paste() {
        BookData.Node node;
        if (!this.state.editable || this.state.page == null || this.state.mode != EditorMode.TEXT_MODE) {
            return;
        }
        if (this.state.clipboard.isEmpty()) {
            return;
        }
        int selectedIdx = this.state.textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx >= 0 && selectedIdx < this.state.page.nodes.size() && (node = this.state.page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode) {
            BookData.TextBoxNode box = (BookData.TextBoxNode)node;
            this.historyManager.pushSnapshotOnce();
            for (char ch : this.state.clipboard.toCharArray()) {
                boolean ok = this.state.textBoxOps.insertChar(box, this.state.textBoxCaret, this.style(), ch);
                if (ok) continue;
                this.state.showTransientMessage("Content limit reached", 3000L);
                break;
            }
            this.historyManager.notifyDirty();
        }
    }

    public void selectAll() {
        BookData.Node node;
        if (this.state.mode != EditorMode.TEXT_MODE) {
            return;
        }
        int selectedIdx = this.state.textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx >= 0 && selectedIdx < this.state.page.nodes.size() && (node = this.state.page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode) {
            BookData.TextBoxNode box = (BookData.TextBoxNode)node;
            this.state.textBoxCaret.selectAll(box);
        }
    }

    public void syncStylesFromSelection() {
        BookData.Node node;
        int selectedIdx;
        if (this.state.textBoxCaret.hasSelection() && (selectedIdx = this.state.textBoxInteraction.getSelectedTextBoxIndex()) >= 0 && selectedIdx < this.state.page.nodes.size() && (node = this.state.page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode) {
            BookData.TextSegment segment;
            BookData.TextBoxNode box = (BookData.TextBoxNode)node;
            int selStart = this.state.textBoxCaret.selectionStart();
            if (selStart < box.getFullText().length() && (segment = this.getSegmentAtPosition(box, selStart)) != null) {
                this.state.bold = segment.bold;
                this.state.italic = segment.italic;
                this.state.underline = segment.underline;
                this.state.argb = segment.argb;
                this.state.size = segment.size;
            }
        }
    }

    public boolean isBold() {
        return this.state.bold;
    }

    public boolean isItalic() {
        return this.state.italic;
    }

    public boolean isUnderline() {
        return this.state.underline;
    }

    public float getSize() {
        return this.state.size;
    }

    public int getColor() {
        return this.state.argb;
    }

    public StyleParams getStyle() {
        return this.style();
    }

    private StyleParams style() {
        return new StyleParams(this.state.bold, this.state.italic, this.state.underline, this.state.argb, this.state.size);
    }

    private BookData.TextSegment getSegmentAtPosition(BookData.TextBoxNode box, int pos) {
        int currentPos = 0;
        for (BookData.TextSegment seg : box.segments) {
            if (pos >= currentPos && pos < currentPos + seg.text.length()) {
                return seg;
            }
            currentPos += seg.text.length();
        }
        return box.segments.isEmpty() ? null : box.segments.get(box.segments.size() - 1);
    }
}

