/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.editor.mode.EditorMode;
import bookeditor.client.editor.textbox.StyleParams;
import bookeditor.client.editor.tools.DrawingTool;
import bookeditor.client.gui.widget.editor.EditorHistoryManager;
import bookeditor.client.gui.widget.editor.EditorState;
import bookeditor.client.gui.widget.editor.EditorWidget;
import bookeditor.data.BookData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class EditorToolManager {
    private final EditorState state;
    private final EditorHistoryManager historyManager;

    public EditorToolManager(EditorState state, EditorHistoryManager historyManager) {
        this.state = state;
        this.historyManager = historyManager;
    }

    public void deactivateAllTools() {
        this.state.drawingTool.setActive(false);
        this.state.eraserTool.setActive(false);
        this.state.textBoxCreationTool.deactivate();
    }

    public void setDrawingToolColor(int argb) {
        this.state.drawingTool.setColor(argb);
    }

    public void setDrawingTool(DrawingTool tool) {
        if (tool == null) {
            this.deactivateAllTools();
            return;
        }
        if (tool == DrawingTool.ERASER) {
            if (this.state.eraserTool.isActive()) {
                this.deactivateAllTools();
                return;
            }
            this.deactivateAllTools();
            this.state.eraserTool.setActive(true);
        } else {
            if (this.state.drawingTool.isActive() && this.state.drawingTool.getCurrentTool() == tool) {
                this.deactivateAllTools();
                return;
            }
            this.deactivateAllTools();
            this.state.drawingTool.setTool(tool);
            this.state.drawingTool.setActive(true);
        }
        this.state.mode = EditorMode.OBJECT_MODE;
        this.state.textBoxInteraction.clearSelection();
    }

    public DrawingTool getCurrentDrawingTool() {
        if (this.state.eraserTool.isActive()) {
            return DrawingTool.ERASER;
        }
        if (this.state.drawingTool.isActive()) {
            return this.state.drawingTool.getCurrentTool();
        }
        return null;
    }

    public void setToolSize(int size) {
        this.state.drawingTool.setSize(size);
        this.state.eraserTool.setSize(size);
    }

    public void activateTextBoxTool() {
        this.deactivateAllTools();
        this.state.textBoxCreationTool.activate();
        this.state.mode = EditorMode.OBJECT_MODE;
    }

    public void insertImage(String url, int w, int h, boolean gif) {
        if (!this.state.editable || this.state.page == null) {
            return;
        }
        if (this.state.page.nodes.size() >= 512) {
            this.state.showTransientMessage("Page node limit reached", 3000L);
            return;
        }
        this.historyManager.pushSnapshotOnce();
        int maxImgW = Math.max(8, 960);
        BookData.ImageNode img = new BookData.ImageNode(url, Math.max(8, Math.min(w, maxImgW)), Math.max(8, h), gif);
        img.absolute = true;
        img.x = 0;
        img.y = Math.max(0, Math.min(this.state.scrollY + 10, Math.max(0, 600 - img.h)));
        if (this.state.onImageUrlSeen != null && url != null && !url.isEmpty()) {
            this.state.onImageUrlSeen.accept(url);
        }
        this.state.page.nodes.add(img);
        this.state.mode = EditorMode.OBJECT_MODE;
        this.historyManager.notifyDirty();
    }

    public boolean mouseScrolled() {
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        EditorWidget widget = this.state.getWidget();
        if (!widget.method_25405(mouseX, mouseY)) {
            return false;
        }
        widget.method_25365(true);
        int mx = (int)mouseX;
        int my = (int)mouseY;
        if (this.state.canPan() && button == 0) {
            this.state.isPanning = true;
            this.state.panStartMouseX = mx;
            this.state.panStartMouseY = my;
            this.state.panStartOffsetX = this.state.panOffsetX;
            this.state.panStartOffsetY = this.state.panOffsetY;
            return true;
        }
        if (!this.state.editable) {
            return true;
        }
        if (this.state.textBoxCreationTool.isActive()) {
            this.historyManager.pushSnapshotOnce();
            BookData.TextBoxNode box = new BookData.TextBoxNode(this.state.textBoxCreationTool.getPreviewX(), this.state.textBoxCreationTool.getPreviewY(), this.state.textBoxCreationTool.getPreviewWidth(), this.state.textBoxCreationTool.getPreviewHeight());
            box.bgArgb = this.state.textBoxBgColor;
            box.setText("", this.state.bold, this.state.italic, this.state.underline, this.state.argb, this.state.size);
            this.state.page.nodes.add(box);
            this.state.textBoxCreationTool.deactivate();
            this.historyManager.notifyDirty();
            return true;
        }
        if (this.state.eraserTool.isActive()) {
            this.historyManager.pushSnapshotOnce();
            this.state.eraserTool.erase(this.state.page, mx, my, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
            this.historyManager.notifyDirty();
            return true;
        }
        if (this.state.drawingTool.isActive()) {
            if (this.state.page.strokes.size() >= 1024) {
                this.state.showTransientMessage("Stroke limit reached", 3000L);
                return true;
            }
            this.historyManager.pushSnapshotOnce();
            this.state.drawingTool.beginStroke(this.state.page, mx, my, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
            return true;
        }
        EditorMode oldMode = this.state.mode;
        this.state.mode = this.state.mouseHandler.handleMouseClick(mx, my, this.state.editable, this.state.page, this.state.mode, this.state.imageInteraction, this.state.textBoxInteraction, this.state.textBoxCaret, this.state.textBoxRenderer, this.state.textRenderer, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY, this.historyManager::pushSnapshotOnce);
        if (this.state.mode == EditorMode.TEXT_MODE || oldMode != this.state.mode) {
            this.state.editorRenderer.resetCaretBlink();
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY) {
        if (this.state.isPanning) {
            int deltaX = (int)mouseX - this.state.panStartMouseX;
            int deltaY = (int)mouseY - this.state.panStartMouseY;
            this.state.panOffsetX = this.state.panStartOffsetX + deltaX;
            this.state.panOffsetY = this.state.panStartOffsetY + deltaY;
            this.state.clampPanOffset();
            return true;
        }
        if (this.state.eraserTool.isActive()) {
            this.state.eraserTool.erase(this.state.page, (int)mouseX, (int)mouseY, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
            this.historyManager.notifyDirty();
            return true;
        }
        if (this.state.drawingTool.isActive()) {
            this.state.drawingTool.continueStroke((int)mouseX, (int)mouseY, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
            return true;
        }
        return this.state.mouseHandler.handleMouseDrag((int)mouseX, (int)mouseY, this.state.mode, this.state.editable, this.state.imageInteraction, this.state.textBoxInteraction, this.state.textBoxCaret, this.state.textBoxRenderer, this.state.textRenderer, this.state.page, this.state.contentScreenLeft(), this.state.contentScreenTop(), this.state.scale(), this.state.scrollY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        EditorWidget widget = this.state.getWidget();
        if (this.state.isPanning) {
            this.state.isPanning = false;
            return widget.superMouseReleased(mouseX, mouseY, button);
        }
        boolean changed = this.state.imageInteraction.mouseReleased();
        changed |= this.state.textBoxInteraction.mouseReleased();
        if (changed |= this.state.drawingTool.endStroke()) {
            this.historyManager.notifyDirty();
        }
        return widget.superMouseReleased(mouseX, mouseY, button);
    }

    public boolean charTyped(char chr) {
        BookData.TextBoxNode box;
        BookData.Node node;
        EditorWidget widget = this.state.getWidget();
        if (!this.state.editable || this.state.page == null || !widget.method_25370()) {
            return false;
        }
        if (this.state.drawingTool.isActive() || this.state.eraserTool.isActive() || this.state.textBoxCreationTool.isActive()) {
            return false;
        }
        int selectedIdx = this.state.textBoxInteraction.getSelectedTextBoxIndex();
        if (selectedIdx >= 0 && selectedIdx < this.state.page.nodes.size() && (node = this.state.page.nodes.get(selectedIdx)) instanceof BookData.TextBoxNode && (box = (BookData.TextBoxNode)node).getFullText().length() >= 5000) {
            return false;
        }
        this.historyManager.pushSnapshotOnce();
        StyleParams style = new StyleParams(this.state.bold, this.state.italic, this.state.underline, this.state.argb, this.state.size);
        boolean handled = this.state.inputHandler.handleCharTyped(this.state.mode, this.state.page, this.state.textBoxInteraction, this.state.textBoxCaret, style, chr);
        if (handled) {
            this.state.editorRenderer.resetCaretBlink();
            this.historyManager.notifyDirty();
        }
        return handled;
    }

    public boolean keyPressed(int keyCode, int modifiers) {
        EditorWidget widget = this.state.getWidget();
        if (!widget.method_25370()) {
            return false;
        }
        if ((keyCode == 261 || keyCode == 259) && this.state.page != null && this.state.mode == EditorMode.OBJECT_MODE) {
            if (this.state.imageInteraction.getSelectedImageIndex() >= 0) {
                this.historyManager.pushSnapshotOnce();
                this.state.imageInteraction.deleteSelectedIfImage(this.state.page);
                this.historyManager.notifyDirty();
                return true;
            }
            if (this.state.textBoxInteraction.getSelectedTextBoxIndex() >= 0) {
                this.historyManager.pushSnapshotOnce();
                this.state.textBoxInteraction.deleteSelectedIfTextBox(this.state.page);
                this.historyManager.notifyDirty();
                return true;
            }
        }
        if (keyCode == 256) {
            if (this.state.textBoxCreationTool.isActive()) {
                this.state.textBoxCreationTool.deactivate();
                return true;
            }
            if (this.state.drawingTool.isActive() || this.state.eraserTool.isActive()) {
                this.deactivateAllTools();
                return true;
            }
            if (this.state.mode == EditorMode.TEXT_MODE) {
                this.state.mode = EditorMode.OBJECT_MODE;
                this.state.textBoxInteraction.setEditingText(false);
                this.state.textBoxCaret.clearSelection();
                return true;
            }
        }
        return this.state.inputHandler.handleKeyPressed(this.state.mode, this.state.page, this.state.textBoxInteraction, this.state.textBoxCaret, keyCode, modifiers);
    }
}

