/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.editor;

import bookeditor.client.editor.tools.DrawingTool;
import bookeditor.client.gui.widget.editor.EditorHistoryManager;
import bookeditor.client.gui.widget.editor.EditorRendererManager;
import bookeditor.client.gui.widget.editor.EditorState;
import bookeditor.client.gui.widget.editor.EditorStyleManager;
import bookeditor.client.gui.widget.editor.EditorToolManager;
import bookeditor.data.BookData;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class EditorWidget
extends class_339 {
    private int widgetHeight;
    private final EditorState state;
    private final EditorHistoryManager historyManager;
    private final EditorStyleManager styleManager;
    private final EditorToolManager toolManager;
    private final EditorRendererManager rendererManager;

    public EditorWidget(class_327 textRenderer, int x, int y, int width, int height, boolean editable, Consumer<String> onImageUrlSeen, Runnable onDirty) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"RichEditor"));
        this.widgetHeight = height;
        this.state = new EditorState(textRenderer, editable, onImageUrlSeen, onDirty, this);
        this.historyManager = new EditorHistoryManager(this.state);
        this.styleManager = new EditorStyleManager(this.state, this.historyManager);
        this.toolManager = new EditorToolManager(this.state, this.historyManager);
        this.rendererManager = new EditorRendererManager(this.state);
        this.field_22763 = true;
    }

    public void setWidgetHeight(int height) {
        this.widgetHeight = height;
    }

    public int method_25364() {
        return this.widgetHeight;
    }

    public boolean superMouseReleased(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public void setHeight(int height) {
        this.state.setHeight(height);
    }

    public void setEditable(boolean editable) {
        this.state.setEditable(editable);
    }

    public void setContent(BookData.Page page) {
        this.state.setContent(page);
        this.historyManager.onContentSet();
    }

    public void markSnapshot() {
        this.historyManager.pushSnapshot();
    }

    public boolean undo() {
        return this.historyManager.undo();
    }

    public boolean redo() {
        return this.historyManager.redo();
    }

    public void setBold(boolean bold) {
        this.styleManager.setBold(bold);
    }

    public void setItalic(boolean italic) {
        this.styleManager.setItalic(italic);
    }

    public void setUnderline(boolean underline) {
        this.styleManager.setUnderline(underline);
    }

    public void setColor(int argb) {
        this.styleManager.setColor(argb);
    }

    public void setSize(float size) {
        this.styleManager.setSize(size);
    }

    public void setTextBoxBgColor(int argb) {
        this.styleManager.setTextBoxBgColor(argb);
    }

    public void setPlankType(String plankType) {
        this.state.setPlankType(plankType);
    }

    public void setDrawingToolColor(int argb) {
        this.toolManager.setDrawingToolColor(argb);
    }

    public void setDrawingTool(DrawingTool tool) {
        this.toolManager.setDrawingTool(tool);
    }

    public DrawingTool getCurrentDrawingTool() {
        return this.toolManager.getCurrentDrawingTool();
    }

    public void setToolSize(int size) {
        this.toolManager.setToolSize(size);
    }

    public void activateTextBoxTool() {
        this.toolManager.activateTextBoxTool();
    }

    public void setAlignment(int align) {
        this.styleManager.setAlignment(align);
    }

    public void insertImage(String url, int w, int h, boolean gif) {
        this.toolManager.insertImage(url, w, h, gif);
    }

    public void applyStyleToSelection() {
        this.styleManager.applyStyleToSelection();
    }

    public void copySelection() {
        this.styleManager.copySelection();
    }

    public void cutSelection() {
        this.styleManager.cutSelection();
    }

    public void paste() {
        this.styleManager.paste();
    }

    public void selectAll() {
        this.styleManager.selectAll();
    }

    public void syncStylesFromSelection() {
        this.styleManager.syncStylesFromSelection();
    }

    public int getColor() {
        return this.styleManager.getColor();
    }

    public boolean isBold() {
        return this.styleManager.isBold();
    }

    public boolean isItalic() {
        return this.styleManager.isItalic();
    }

    public boolean isUnderline() {
        return this.styleManager.isUnderline();
    }

    public float getSize() {
        return this.styleManager.getSize();
    }

    public void showTransientMessage(String msg, long durationMillis) {
        this.state.showTransientMessage(msg, durationMillis);
    }

    public boolean isEditable() {
        return this.state.editable;
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.rendererManager.renderButton(ctx, mouseX, mouseY, delta);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        return this.toolManager.mouseScrolled();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.toolManager.mouseClicked(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dx, double dy) {
        return this.toolManager.mouseDragged(mouseX, mouseY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.toolManager.mouseReleased(mouseX, mouseY, button);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.toolManager.charTyped(chr);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.toolManager.keyPressed(keyCode, modifiers);
    }

    protected void method_47399(class_6382 builder) {
    }

    public boolean isTextBoxToolActive() {
        return this.state.textBoxCreationTool.isActive();
    }

    public int getPageNodeCount() {
        if (this.state.page == null) {
            return 0;
        }
        return this.state.page.nodes.size();
    }

    public int getPageStrokeCount() {
        if (this.state.page == null) {
            return 0;
        }
        return this.state.page.strokes.size();
    }

    public void setUserZoom(float zoom) {
        this.state.setUserZoom(zoom);
    }
}

