/*
 * Decompiled with CFR 0.152.
 */
package bookeditor.client.gui.widget.zoom;

import bookeditor.client.gui.widget.zoom.ZoomSliderState;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ZoomSliderInputHandler {
    private final ZoomSliderState state;
    private final Consumer<Float> onZoomChange;

    public ZoomSliderInputHandler(ZoomSliderState state, Consumer<Float> onZoomChange) {
        this.state = state;
        this.onZoomChange = onZoomChange;
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int x, int y, int width, int height) {
        int trackPadding = 20;
        int trackY = y + trackPadding;
        int trackHeight = height - trackPadding * 2 - 16;
        if (mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)trackY && mouseY < (double)(trackY + trackHeight)) {
            this.state.dragging = true;
            this.updateZoomFromMouse(mouseY, trackY, trackHeight);
            return true;
        }
        return false;
    }

    public boolean handleMouseDrag(double mouseY, int y, int height) {
        if (!this.state.dragging) {
            return false;
        }
        int trackPadding = 20;
        int trackY = y + trackPadding;
        int trackHeight = height - trackPadding * 2 - 16;
        this.updateZoomFromMouse(mouseY, trackY, trackHeight);
        return true;
    }

    public void handleMouseRelease() {
        this.state.dragging = false;
    }

    public boolean handleMouseScroll(double amount, int x, int y, int width, int height, double mouseX, double mouseY) {
        if (mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height)) {
            float delta = (float)(amount * 0.25);
            this.state.setZoom(this.state.zoomLevel + delta);
            this.onZoomChange.accept(Float.valueOf(this.state.zoomLevel));
            return true;
        }
        return false;
    }

    private void updateZoomFromMouse(double mouseY, int trackY, int trackHeight) {
        float normalized = 1.0f - (float)((mouseY - (double)trackY) / (double)(trackHeight - 8));
        normalized = Math.max(0.0f, Math.min(1.0f, normalized));
        this.state.setFromNormalizedPosition(normalized);
        this.onZoomChange.accept(Float.valueOf(this.state.zoomLevel));
    }
}

